/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.event;

import java.util.HashMap;
import java.util.Map;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.event.EventListener;
import net.dynamicdev.anticheat.util.Distance;
import net.dynamicdev.anticheat.util.Permission;
import net.dynamicdev.anticheat.util.User;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.PlayerInventory;

public class PlayerListener
extends EventListener {
    private Map<String, Location> setbackLocation = new HashMap<String, Location>();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        CheckResult result;
        Player player = event.getPlayer();
        if (PlayerListener.getCheckManager().willCheck(player, CheckType.COMMAND_SPAM) && !Permission.getCommandExempt((CommandSender)player, event.getMessage().split(" ")[0]) && (result = PlayerListener.getBackend().getChatCheck().checkCommandSpam(player, event.getMessage())).failed()) {
            event.setCancelled(!PlayerListener.silentMode());
            if (!PlayerListener.silentMode()) {
                player.sendMessage(ChatColor.RED + result.getMessage());
            }
            PlayerListener.getBackend().getChatCheck().processCommandSpammer(player);
            PlayerListener.log(null, player, CheckType.COMMAND_SPAM);
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        if (!event.isFlying()) {
            PlayerListener.getBackend().logEnterExit(event.getPlayer());
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getNewGameMode() != GameMode.CREATIVE) {
            PlayerListener.getBackend().logEnterExit(event.getPlayer());
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() instanceof Player) {
            CheckResult result;
            Player player = (Player)event.getEntity().getShooter();
            if (event.getEntity() instanceof Arrow) {
                return;
            }
            if (PlayerListener.getCheckManager().willCheck(player, CheckType.FAST_PROJECTILE) && (result = PlayerListener.getBackend().getEntityCheck().checkProjectile(player)).failed()) {
                event.setCancelled(!PlayerListener.silentMode());
                PlayerListener.log(result.getMessage(), player, CheckType.FAST_PROJECTILE);
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL || event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
            PlayerListener.getBackend().logTeleport(event.getPlayer());
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerChangeWorlds(PlayerChangedWorldEvent event) {
        PlayerListener.getBackend().logTeleport(event.getPlayer());
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (event.isSneaking()) {
            PlayerListener.getBackend().logToggleSneak(event.getPlayer());
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerVelocity(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        if (PlayerListener.getCheckManager().willCheck(player, CheckType.FLY)) {
            if (PlayerListener.getBackend().getMovementCheck().justVelocity(player) && PlayerListener.getBackend().getMovementCheck().extendVelocityTime(player)) {
                event.setCancelled(!PlayerListener.silentMode());
                return;
            }
            PlayerListener.getBackend().getMovementCheck().logVelocity(player);
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        CheckResult result;
        Player player = event.getPlayer();
        if (PlayerListener.getCheckManager().willCheck(player, CheckType.CHAT_SPAM) && (result = PlayerListener.getBackend().getChatCheck().checkChatSpam(player, event.getMessage())).failed()) {
            event.setCancelled(!PlayerListener.silentMode());
            if (!result.getMessage().equals("") && !PlayerListener.silentMode()) {
                player.sendMessage(ChatColor.RED + result.getMessage());
            }
            PlayerListener.getBackend().getChatCheck().processChatSpammer(player);
            PlayerListener.log(null, player, CheckType.CHAT_SPAM);
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        User user = PlayerListener.getUserManager().getUser(event.getPlayer().getName());
        PlayerListener.getConfig().getLevels().saveLevelFromUser(user);
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        if (!event.isSprinting()) {
            PlayerListener.getBackend().logEnterExit(player);
        }
        if (PlayerListener.getCheckManager().willCheck(player, CheckType.SPRINT)) {
            CheckResult result = PlayerListener.getBackend().getMovementCheck().checkSprintHungry(event);
            if (result.failed()) {
                event.setCancelled(!PlayerListener.silentMode());
                PlayerListener.log(result.getMessage(), player, CheckType.SPRINT);
            } else {
                PlayerListener.decrease(player);
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block;
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Material m = inv.getItemInHand().getType();
            if (m == Material.BOW) {
                PlayerListener.getBackend().getEntityCheck().logBowWindUp(player);
            } else if (Utilities.isFood(m)) {
                PlayerListener.getBackend().getEntityCheck().logEatingStart(player);
            }
        }
        if ((block = event.getClickedBlock()) != null) {
            Distance distance = new Distance(player.getLocation(), block.getLocation());
            PlayerListener.getBackend().getBlockCheck().checkLongReachBlock(player, distance.getXDifference(), distance.getYDifference(), distance.getZDifference());
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        CheckResult result;
        Player player = event.getPlayer();
        if (PlayerListener.getCheckManager().willCheck(player, CheckType.ITEM_SPAM) && (result = PlayerListener.getBackend().getInventoryCheck().checkFastDrop(player)).failed()) {
            event.setCancelled(!PlayerListener.silentMode());
            PlayerListener.log(result.getMessage(), player, CheckType.ITEM_SPAM);
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerEnterBed(PlayerBedEnterEvent event) {
        if (event.getBed().getType() != Material.BED) {
            return;
        }
        PlayerListener.getBackend().logEnterExit(event.getPlayer());
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerExitBed(PlayerBedLeaveEvent event) {
        if (event.getBed().getType() != Material.BED) {
            return;
        }
        PlayerListener.getBackend().logEnterExit(event.getPlayer());
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerAnimation(PlayerAnimationEvent event) {
        PlayerListener.getBackend().getBlockCheck().logAnimation(event.getPlayer());
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String section = "\u00a7";
        if (PlayerListener.getCheckManager().willCheck(player, CheckType.ZOMBE_FLY)) {
            player.sendMessage(section + "f " + section + "f " + section + "1 " + section + "0 " + section + "2 " + section + "4");
        }
        if (PlayerListener.getCheckManager().willCheck(player, CheckType.ZOMBE_CHEAT)) {
            player.sendMessage(section + "f " + section + "f " + section + "2 " + section + "0 " + section + "4 " + section + "8");
        }
        if (PlayerListener.getCheckManager().willCheck(player, CheckType.ZOMBE_NOCLIP)) {
            player.sendMessage(section + "f " + section + "f " + section + "4 " + section + "0 " + section + "9 " + section + "6");
        }
        PlayerListener.getBackend().logJoin(player);
        User user = new User(player.getName());
        user.setIsWaitingOnLevelSync(true);
        PlayerListener.getConfig().getLevels().loadLevelToUser(user);
        PlayerListener.getUserManager().addUser(user);
        if (player.hasMetadata("ac-spydata")) {
            for (Player p : player.getServer().getOnlinePlayers()) {
                if (Permission.SYSTEM_SPY.get((CommandSender)p)) continue;
                p.hidePlayer(player);
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        boolean setBack = false;
        if (!this.setbackLocation.containsKey(player.getName())) {
            this.setbackLocation.put(player.getName(), player.getLocation());
        }
        if (player == null || player.getName() == null) {
            return;
        }
        if (PlayerListener.getCheckManager().checkInWorld(player) && !PlayerListener.getCheckManager().isOpExempt(player)) {
            CheckResult result;
            Location from = event.getFrom();
            Location to = event.getTo();
            Distance distance = new Distance(from, to);
            double y = distance.getYDifference();
            PlayerListener.getBackend().getMovementCheck().logAscension(player, from.getY(), to.getY());
            User user = PlayerListener.getUserManager().getUser(player.getName());
            user.setTo(to.getX(), to.getY(), to.getZ());
            if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.SPEED) && (result = PlayerListener.getBackend().getMovementCheck().checkFreeze(player, from.getY(), to.getY())).failed()) {
                PlayerListener.log(result.getMessage(), player, CheckType.SPEED);
                if (!PlayerListener.silentMode() && !AntiCheat.developerMode()) {
                    player.kickPlayer("Freezing client");
                }
            }
            if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.SPRINT) && (result = PlayerListener.getBackend().getMovementCheck().checkSprintStill(player, from, to)).failed()) {
                event.setCancelled(!PlayerListener.silentMode());
                PlayerListener.log(result.getMessage(), player, CheckType.SPRINT);
            }
            if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.FLY) && !player.isFlying() && (result = PlayerListener.getBackend().getMovementCheck().checkFlight(player, distance)).failed()) {
                if (!PlayerListener.silentMode()) {
                    setBack = true;
                }
                PlayerListener.log(result.getMessage(), player, CheckType.FLY);
            }
            if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.FLY) && !player.isFlying() && (result = PlayerListener.getBackend().getMovementCheck().checkGlide(player)).failed()) {
                if (!PlayerListener.silentMode()) {
                    setBack = true;
                }
                PlayerListener.log(result.getMessage(), player, CheckType.FLY);
            }
            if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.VCLIP) && event.getFrom().getY() > event.getTo().getY() && (result = PlayerListener.getBackend().getMovementCheck().checkVClip(player, new Distance(event.getFrom(), event.getTo()))).failed()) {
                if (!PlayerListener.silentMode()) {
                    setBack = true;
                }
                PlayerListener.log(result.getMessage(), player, CheckType.VCLIP);
            }
            if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.VCLIP) && (result = PlayerListener.getBackend().getMovementCheck().checkNoclip(player)).failed()) {
                if (!PlayerListener.silentMode()) {
                    setBack = true;
                }
                PlayerListener.log(result.getMessage(), player, CheckType.VCLIP);
            }
            if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.NOFALL) && PlayerListener.getCheckManager().willCheck(player, CheckType.FLY) && !Utilities.isClimbableBlock(player.getLocation().getBlock()) && event.getFrom().getY() > event.getTo().getY() && (result = PlayerListener.getBackend().getMovementCheck().checkNoFall(player, y)).failed()) {
                if (!PlayerListener.silentMode()) {
                    setBack = true;
                    player.damage(1.0);
                }
                PlayerListener.log(result.getMessage(), player, CheckType.NOFALL);
            }
            boolean changed = false;
            if (event.getTo() != event.getFrom()) {
                CheckResult result2;
                double x = distance.getXDifference();
                double z = distance.getZDifference();
                if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.SPEED) && PlayerListener.getCheckManager().willCheck(player, CheckType.FLY)) {
                    CheckResult result1;
                    if (event.getFrom().getY() < event.getTo().getY() && (result2 = PlayerListener.getBackend().getMovementCheck().checkYSpeed(player, y)).failed()) {
                        if (!PlayerListener.silentMode()) {
                            setBack = true;
                        }
                        PlayerListener.log(result2.getMessage(), player, CheckType.SPEED);
                        changed = true;
                    }
                    if ((result2 = PlayerListener.getBackend().getMovementCheck().checkXZSpeed(player, x, z)).failed()) {
                        if (!PlayerListener.silentMode()) {
                            setBack = true;
                        }
                        PlayerListener.log(result2.getMessage(), player, CheckType.SPEED);
                        changed = true;
                    }
                    if ((event.getFrom().getX() != event.getTo().getX() || event.getFrom().getZ() != event.getTo().getZ()) && PlayerListener.getCheckManager().willCheckQuick(player, CheckType.MOREPACKETS) && (result1 = PlayerListener.getBackend().getMovementCheck().checkTimer(player)).failed()) {
                        if (!PlayerListener.silentMode()) {
                            setBack = true;
                        }
                        PlayerListener.log(result1.getMessage(), player, CheckType.MOREPACKETS);
                        changed = true;
                    }
                }
                if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.WATER_WALK) && (result2 = PlayerListener.getBackend().getMovementCheck().checkWaterWalk(player, x, y, z)).failed()) {
                    if (!PlayerListener.silentMode()) {
                        setBack = true;
                    }
                    PlayerListener.log(result2.getMessage(), player, CheckType.WATER_WALK);
                    changed = true;
                }
                if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.SNEAK) && (result2 = PlayerListener.getBackend().getMovementCheck().checkSneak(player, x, z)).failed()) {
                    if (!PlayerListener.silentMode()) {
                        setBack = true;
                        player.setSneaking(false);
                    }
                    PlayerListener.log(result2.getMessage(), player, CheckType.SNEAK);
                    changed = true;
                }
                if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.SPIDER) && (result2 = PlayerListener.getBackend().getMovementCheck().checkSpider(player, y)).failed()) {
                    if (!PlayerListener.silentMode()) {
                        setBack = true;
                    }
                    PlayerListener.log(result2.getMessage(), player, CheckType.SPIDER);
                    changed = true;
                }
                if (PlayerListener.getCheckManager().willCheckQuick(player, CheckType.VELOCITY) && (result2 = PlayerListener.getBackend().getMovementCheck().checkVelocitized(player, distance)).failed()) {
                    PlayerListener.log(result2.getMessage(), player, CheckType.VELOCITY);
                }
                if (!changed) {
                    user.setGoodLocation(event.getFrom());
                }
            }
            if (setBack) {
                player.teleport(this.setbackLocation.get(player.getName()));
            } else if (Utilities.isSafeSetbackLocation(player)) {
                this.setbackLocation.put(player.getName(), player.getLocation());
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void checkFly(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        User user = PlayerListener.getUserManager().getUser(player.getName());
        Location from = event.getFrom();
        Location to = event.getTo();
        if (!user.checkTo(to.getX(), to.getY(), to.getZ())) {
            return;
        }
        if (PlayerListener.getCheckManager().willCheck(player, CheckType.FLY) && !player.isFlying()) {
            String log;
            CheckResult result1 = PlayerListener.getBackend().getMovementCheck().checkYAxis(player, new Distance(from, to));
            CheckResult result2 = PlayerListener.getBackend().getMovementCheck().checkAscension(player, from.getY(), to.getY());
            String string = result1.failed() ? result1.getMessage() : (log = result2.failed() ? result2.getMessage() : "");
            if (!log.equals("")) {
                if (!PlayerListener.silentMode()) {
                    event.setTo(user.getGoodLocation(from.clone()));
                }
                PlayerListener.log(log, player, CheckType.FLY);
            }
        }
    }
}

