/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.event;

import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.event.EventListener;
import net.dynamicdev.anticheat.util.User;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;

public class InventoryListener
extends EventListener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.isRightClick() && !event.isShiftClick() && event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            if (InventoryListener.getCheckManager().willCheck(player, CheckType.FAST_INVENTORY)) {
                CheckResult result = InventoryListener.getBackend().getInventoryCheck().checkInventoryClicks(player);
                if (result.failed()) {
                    if (!InventoryListener.silentMode()) {
                        player.getInventory().clear();
                        event.setCancelled(true);
                    }
                    InventoryListener.log(result.getMessage(), player, CheckType.FAST_INVENTORY);
                } else {
                    InventoryListener.decrease(player);
                }
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (event.getInventory().getType() != InventoryType.BEACON) {
            InventoryListener.getUserManager().getUser(event.getPlayer().getName()).setInventorySnapshot(event.getInventory().getContents());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        User user = InventoryListener.getUserManager().getUser(event.getPlayer().getName());
        if (user != null) {
            user.removeInventorySnapshot();
        }
    }
}

