/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.event;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.Backend;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import net.dynamicdev.anticheat.manage.CheckManager;
import net.dynamicdev.anticheat.manage.UserManager;
import net.dynamicdev.anticheat.util.Permission;
import net.dynamicdev.anticheat.util.User;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class EventListener
implements Listener {
    private static final Map<CheckType, Integer> USAGE_LIST = new EnumMap<CheckType, Integer>(CheckType.class);
    private static final Map<String, Integer> DECREASE_LIST = new HashMap<String, Integer>();
    private static final CheckManager CHECK_MANAGER = AntiCheat.getManager().getCheckManager();
    private static final Backend BACKEND = AntiCheat.getManager().getBackend();
    private static final AntiCheat PLUGIN = AntiCheat.getManager().getPlugin();
    private static final UserManager USER_MANAGER = AntiCheat.getManager().getUserManager();
    private static final Configuration CONFIG = AntiCheat.getManager().getConfiguration();

    public static void log(String message, Player player, CheckType type) {
        User user = EventListener.getUserManager().getUser(player.getName());
        if (user != null) {
            EventListener.logCheat(type, user);
            if (user.increaseLevel(type) && message != null) {
                AntiCheat.getManager().log(message);
                for (Player thePlayer : AntiCheat.getPlugin().getServer().getOnlinePlayers()) {
                    if (!Permission.SYSTEM_ALERTALL.get((CommandSender)thePlayer) || EventListener.silentMode() || !AntiCheat.developerMode()) continue;
                    thePlayer.sendMessage(ChatColor.RED + "[AntiCheat+] " + message);
                }
            }
            EventListener.removeDecrease(user);
        }
    }

    private static void logCheat(CheckType type, User user) {
        USAGE_LIST.put(type, EventListener.getCheats(type) + 1);
        if (user != null && user.getName() != null) {
            type.logUse(user);
            if (EventListener.CONFIG.getConfig().enterprise.getValue().booleanValue() && EventListener.CONFIG.getEnterprise().loggingEnabled.getValue().booleanValue()) {
                EventListener.CONFIG.getEnterprise().database.logEvent(user, type);
            }
        }
    }

    public void resetCheck(CheckType type) {
        USAGE_LIST.put(type, 0);
    }

    public static int getCheats(CheckType type) {
        int x = 0;
        if (USAGE_LIST.get((Object)type) != null) {
            x = USAGE_LIST.get((Object)type);
        }
        return x;
    }

    private static void removeDecrease(User user) {
        int x = 0;
        if (user.getName() != null) {
            if (DECREASE_LIST.get(user.getName()) != null) {
                x = DECREASE_LIST.get(user.getName());
                if ((x -= 2) < 0) {
                    x = 0;
                }
            }
            DECREASE_LIST.put(user.getName(), x);
        }
    }

    public static void decrease(Player player) {
        User user = EventListener.getUserManager().getUser(player.getName());
        if (user.getName() != null) {
            int x = 0;
            if (DECREASE_LIST.get(user.getName()) != null) {
                x = DECREASE_LIST.get(user.getName());
            }
            DECREASE_LIST.put(user.getName(), ++x);
            if (x >= 10) {
                user.decreaseLevel();
                DECREASE_LIST.put(user.getName(), 0);
            }
        }
    }

    public static CheckManager getCheckManager() {
        return CHECK_MANAGER;
    }

    public static AntiCheatManager getManager() {
        return AntiCheat.getManager();
    }

    public static Backend getBackend() {
        return BACKEND;
    }

    public static UserManager getUserManager() {
        return USER_MANAGER;
    }

    public static AntiCheat getPlugin() {
        return PLUGIN;
    }

    public static Configuration getConfig() {
        return CONFIG;
    }

    public static boolean silentMode() {
        return EventListener.CONFIG.getConfig().silentMode.getValue();
    }
}

