/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.event;

import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.event.EventListener;
import net.dynamicdev.anticheat.util.Distance;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class EntityListener
extends EventListener {
    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (EntityListener.getCheckManager().willCheck(player, CheckType.FAST_BOW)) {
                CheckResult result = EntityListener.getBackend().getEntityCheck().checkFastBow(player, event.getForce());
                if (result.failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.FAST_BOW);
                } else {
                    EntityListener.decrease(player);
                }
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (event.getEntity() instanceof Player && event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED) {
            Player player = (Player)event.getEntity();
            if (EntityListener.getCheckManager().willCheck(player, CheckType.FAST_HEAL)) {
                CheckResult result = EntityListener.getBackend().getEntityCheck().checkFastHeal(player);
                if (result.failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.FAST_HEAL);
                } else {
                    EntityListener.decrease(player);
                    EntityListener.getBackend().getEntityCheck().logHeal(player);
                }
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).getFoodLevel() < event.getFoodLevel() && EntityListener.getCheckManager().willCheck(player, CheckType.FAST_EAT)) {
            CheckResult result = EntityListener.getBackend().getEntityCheck().checkFastEat(player);
            if (result.failed()) {
                event.setCancelled(!EntityListener.silentMode());
                EntityListener.log(result.getMessage(), player, CheckType.FAST_EAT);
            } else {
                EntityListener.decrease(player);
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        boolean noHack = true;
        if (event instanceof EntityDamageByEntityEvent) {
            Player player;
            EntityDamageByEntityEvent e = (EntityDamageByEntityEvent)event;
            if (event.getEntity() instanceof Player) {
                Arrow arrow;
                player = (Player)event.getEntity();
                if (e.getDamager() instanceof Arrow && (arrow = (Arrow)e.getDamager()).getShooter() instanceof Player && event.getEntity() == arrow.getShooter()) {
                    event.setCancelled(true);
                }
                if (Utilities.hasArmorEnchantment(player, Enchantment.THORNS)) {
                    EntityListener.getBackend().getBlockCheck().logAnimation(player);
                }
                if (e.getDamager() instanceof Player) {
                    Player p = (Player)e.getDamager();
                    EntityListener.getBackend().logDamage(p, 1);
                    int value = p.getInventory().getItemInHand().containsEnchantment(Enchantment.KNOCKBACK) ? 2 : 1;
                    EntityListener.getBackend().logDamage(player, value);
                    if (EntityListener.getCheckManager().willCheck(p, CheckType.LONG_REACH)) {
                        Distance distance = new Distance(player.getLocation(), p.getLocation());
                        CheckResult result = EntityListener.getBackend().getEntityCheck().checkLongReachDamage(player, distance.getXDifference(), distance.getYDifference(), distance.getZDifference());
                        if (result.failed()) {
                            event.setCancelled(!EntityListener.silentMode());
                            EntityListener.log(result.getMessage(), p, CheckType.LONG_REACH);
                            noHack = false;
                        }
                    }
                } else if (e.getDamager() instanceof TNTPrimed || e.getDamager() instanceof Creeper) {
                    EntityListener.getBackend().logDamage(player, 3);
                } else {
                    EntityListener.getBackend().logDamage(player, 1);
                }
            }
            if (e.getDamager() instanceof Player) {
                LivingEntity damaged;
                CheckResult result;
                player = (Player)e.getDamager();
                EntityListener.getBackend().logDamage(player, 1);
                if (EntityListener.getCheckManager().willCheck(player, CheckType.AUTOTOOL) && (result = EntityListener.getBackend().getBlockCheck().checkAutoTool(player)).failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.AUTOTOOL);
                    noHack = false;
                }
                if (EntityListener.getCheckManager().willCheck(player, CheckType.FORCEFIELD) && (result = EntityListener.getBackend().getEntityCheck().checkFightSpeed(player)).failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.AUTOTOOL);
                    noHack = false;
                }
                if (EntityListener.getCheckManager().willCheck(player, CheckType.FORCEFIELD) && (result = EntityListener.getBackend().getEntityCheck().checkSprintDamage(player)).failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.FORCEFIELD);
                    noHack = false;
                }
                if (EntityListener.getCheckManager().willCheck(player, CheckType.DIRECTION) && event.getEntity() instanceof LivingEntity) {
                    damaged = (LivingEntity)event.getEntity();
                    CheckResult result2 = EntityListener.getBackend().getEntityCheck().checkFightRotation(player, damaged);
                    if (result2.failed()) {
                        event.setCancelled(!EntityListener.silentMode());
                        EntityListener.log(result2.getMessage(), player, CheckType.DIRECTION);
                        noHack = false;
                    }
                }
                if (EntityListener.getCheckManager().willCheck(player, CheckType.FORCEFIELD) && event.getEntity() instanceof LivingEntity) {
                    damaged = (LivingEntity)event.getEntity();
                    CheckResult result3 = EntityListener.getBackend().getEntityCheck().checkFightDistance(player, damaged);
                    if (result3.failed()) {
                        event.setCancelled(!EntityListener.silentMode());
                        EntityListener.log(result3.getMessage(), player, CheckType.FORCEFIELD);
                        noHack = false;
                    }
                }
                if (EntityListener.getCheckManager().willCheck(player, CheckType.NO_SWING) && (result = EntityListener.getBackend().getEntityCheck().checkAnimation(player, event.getEntity())).failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.NO_SWING);
                    noHack = false;
                }
                if (EntityListener.getCheckManager().willCheck(player, CheckType.FORCEFIELD) && (result = EntityListener.getBackend().getEntityCheck().checkSight(player, e.getEntity())).failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.FORCEFIELD);
                    noHack = false;
                }
                if (noHack) {
                    EntityListener.decrease(player);
                }
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }
}

