/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.event;

import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.event.EventListener;
import net.dynamicdev.anticheat.util.Distance;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockListener
extends EventListener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockDamage(BlockDamageEvent event) {
        CheckResult result;
        Player player = event.getPlayer();
        if (event.getInstaBreak() || Utilities.isInstantBreak(event.getBlock().getType())) {
            BlockListener.getBackend().getBlockCheck().logInstantBreak(player);
        }
        if (BlockListener.getCheckManager().willCheck(player, CheckType.AUTOTOOL) && (result = BlockListener.getBackend().getBlockCheck().checkAutoTool(player)).failed()) {
            event.setCancelled(!BlockListener.silentMode());
            BlockListener.log(result.getMessage(), player, CheckType.AUTOTOOL);
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (player != null && BlockListener.getCheckManager().willCheck(player, CheckType.FAST_PLACE)) {
            CheckResult result = BlockListener.getBackend().getBlockCheck().checkFastPlace(player);
            if (result.failed()) {
                event.setCancelled(!BlockListener.silentMode());
                BlockListener.log(result.getMessage(), player, CheckType.FAST_PLACE);
            } else {
                BlockListener.decrease(player);
                BlockListener.getBackend().getBlockCheck().logBlockPlace(player);
            }
        }
        AntiCheat.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        boolean noHack = true;
        if (player != null) {
            CheckResult result;
            if (BlockListener.getCheckManager().willCheck(player, CheckType.FAST_BREAK) && (result = BlockListener.getBackend().getBlockCheck().checkFastBreak(player, block)).failed()) {
                event.setCancelled(!BlockListener.silentMode());
                BlockListener.log(result.getMessage(), player, CheckType.FAST_BREAK);
                noHack = false;
            }
            if (BlockListener.getCheckManager().willCheck(player, CheckType.NO_SWING) && (result = BlockListener.getBackend().getBlockCheck().checkSwing(player, block)).failed()) {
                event.setCancelled(!BlockListener.silentMode());
                BlockListener.log(result.getMessage(), player, CheckType.NO_SWING);
                noHack = false;
            }
            if (BlockListener.getCheckManager().willCheck(player, CheckType.LONG_REACH)) {
                Distance distance = new Distance(player.getLocation(), block.getLocation());
                result = BlockListener.getBackend().getBlockCheck().checkLongReachBlock(player, distance.getXDifference(), distance.getYDifference(), distance.getZDifference());
                if (result.failed()) {
                    event.setCancelled(!BlockListener.silentMode());
                    BlockListener.log(result.getMessage(), player, CheckType.LONG_REACH);
                    noHack = false;
                }
            }
            if (BlockListener.getCheckManager().willCheck(player, CheckType.DIRECTION) && (result = BlockListener.getBackend().getBlockCheck().checkBlockRotation(player, event)).failed()) {
                event.setCancelled(!BlockListener.silentMode());
                BlockListener.log(result.getMessage(), player, CheckType.DIRECTION);
                noHack = false;
            }
        }
        if (noHack) {
            BlockListener.decrease(player);
        }
        BlockListener.getBackend().getBlockCheck().logBlockBreak(player);
    }
}

