/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.config.holders.yaml;

import java.util.List;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.config.ConfigurationFile;
import net.dynamicdev.anticheat.config.providers.Levels;
import net.dynamicdev.anticheat.util.User;

public class YamlLevelsHolder
extends ConfigurationFile
implements Levels {
    public static final String FILENAME = "data/levels.yml";

    public YamlLevelsHolder(AntiCheat plugin, Configuration config) {
        super(plugin, config, FILENAME, false);
    }

    @Override
    public void loadLevelToUser(User user) {
        user.setLevel(this.getLevel(user.getName()));
    }

    @Override
    public void saveLevelFromUser(User user) {
        this.saveLevelFromUser(user, true);
    }

    private void saveLevelFromUser(User user, boolean remove) {
        this.saveLevel(user.getName(), user.getLevel());
        if (remove) {
            AntiCheat.getManager().getUserManager().remove(user);
        }
    }

    @Override
    public void saveLevelsFromUsers(List<User> users) {
        for (User user : users) {
            this.saveLevelFromUser(user, false);
        }
    }

    @Override
    public void updateLevelToUser(User user) {
    }

    private int getLevel(String name) {
        ConfigurationFile.ConfigValue level = new ConfigurationFile.ConfigValue(name, false);
        if (level.hasValue()) {
            return (Integer)level.getValue();
        }
        return 0;
    }

    private void saveLevel(String name, int level) {
        new ConfigurationFile.ConfigValue<Integer>(name, false).setValue(new Integer(level));
    }
}

