/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.config.holders.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.config.ConfigurationFile;
import net.dynamicdev.anticheat.config.providers.Groups;
import net.dynamicdev.anticheat.util.Group;

public class YamlGroupsHolder
extends ConfigurationFile
implements Groups {
    public static final String FILENAME = "groups.yml";
    private List<Group> groups;
    private int highestLevel;

    public YamlGroupsHolder(AntiCheat plugin, Configuration config) {
        super(plugin, config, FILENAME);
    }

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public int getHighestLevel() {
        return this.highestLevel;
    }

    @Override
    public void open() {
        ConfigurationFile.ConfigValue groups = new ConfigurationFile.ConfigValue("groups");
        this.groups = new ArrayList<Group>();
        for (String string : (List)groups.getValue()) {
            Group group = Group.load(string);
            if (group == null || group.getLevel() < 0) continue;
            this.groups.add(group);
            this.highestLevel = group.getLevel() > this.highestLevel ? group.getLevel() : this.highestLevel;
        }
        Collections.sort(this.groups, new Comparator<Group>(){

            @Override
            public int compare(Group l1, Group l2) {
                if (l1.getLevel() == l2.getLevel()) {
                    return 0;
                }
                if (l1.getLevel() < l2.getLevel()) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

