/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.config.holders.mysql;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.config.ConfigurationTable;
import net.dynamicdev.anticheat.config.providers.Magic;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MySQLMagicHolder
extends ConfigurationTable
implements InvocationHandler {
    private static final String TABLE = "magic";
    private HashMap<String, Integer> ints;
    private HashMap<String, Double> doubles;
    private FileConfiguration defaults;

    public MySQLMagicHolder(Configuration config) {
        super(config, TABLE);
    }

    @Override
    public void open() {
        this.defaults = YamlConfiguration.loadConfiguration((InputStream)AntiCheat.getPlugin().getResource("magic.yml"));
        this.ints = new HashMap();
        this.doubles = new HashMap();
        String sqlCreate = "CREATE TABLE " + this.getFullTable() + "(" + "  `id` INT NOT NULL AUTO_INCREMENT," + "  `key` VARCHAR(45) NOT NULL," + "  `value_int` INT," + "  `value_double` DOUBLE," + "  PRIMARY KEY (`id`));";
        String sqlPopulate = "INSERT INTO " + this.getFullTable() + " (`key`, `value_int`, `value_double`) " + "SELECT t.*" + "FROM (";
        Method[] methods = Magic.class.getMethods();
        for (int i = 1; i <= methods.length; ++i) {
            String key = methods[i - 1].getName();
            Object value = this.defaults.get(key);
            String type1 = methods[i - 1].getReturnType().getSimpleName();
            String type2 = type1.equals("int") ? "double" : "int";
            sqlPopulate = sqlPopulate + "(SELECT '" + key + "' as `key`, " + (type1.equals("int") ? value : "null") + " as value_" + type1 + ", " + (type1.equals("double") ? value : "null") + " as value_" + type2 + ")";
            if (i >= methods.length) continue;
            sqlPopulate = sqlPopulate + " UNION ALL ";
        }
        sqlPopulate = sqlPopulate + ") t;";
        String sqlLoad = "SELECT * FROM " + this.getFullTable();
        try {
            if (!this.tableExists()) {
                this.getConnection().prepareStatement(sqlCreate).executeUpdate();
                this.getConnection().prepareStatement(sqlPopulate).executeUpdate();
                this.getConnection().commit();
            }
            ResultSet set = this.getConnection().prepareStatement(sqlLoad).executeQuery();
            while (set.next()) {
                String key = set.getString("key");
                if (set.getObject("value_int") != null) {
                    this.ints.put(key, set.getInt("value_int"));
                    continue;
                }
                if (set.getObject("value_double") != null) {
                    this.doubles.put(key, set.getDouble("value_double"));
                    continue;
                }
                AntiCheat.getPlugin().getLogger().severe("The magic value " + key + " loaded from the database did not have a value configured. Using the default value.");
                for (int i = 1; i <= methods.length; ++i) {
                    String name = methods[i - 1].getName();
                    if (!name.equalsIgnoreCase(key)) continue;
                    String type = methods[i - 1].getReturnType().getSimpleName();
                    if (type.equals("int")) {
                        this.ints.put(key, this.defaults.getInt(key));
                        continue;
                    }
                    if (!type.equals("double")) continue;
                    this.doubles.put(key, this.defaults.getDouble(key));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String key = method.getName();
        if (this.ints.containsKey(key)) {
            return (int)this.ints.get(key);
        }
        if (this.doubles.containsKey(key)) {
            return (double)this.doubles.get(key);
        }
        if (this.defaults.getString(key) != null) {
            if (method.getReturnType().getSimpleName().equals("int")) {
                int value = this.defaults.getInt(key);
                try {
                    this.getConnection().prepareStatement("INSERT INTO " + this.getFullTable() + " (key, value_int) VALUES ('" + key + "' , '" + value + "')").executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.reload();
                return value;
            }
            if (method.getReturnType().getSimpleName().equals("double")) {
                double value = this.defaults.getDouble(key);
                try {
                    this.getConnection().prepareStatement("INSERT INTO " + this.getFullTable() + " (key, value_double) VALUES ('" + key + "' , '" + value + "')").executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.reload();
                return value;
            }
        }
        AntiCheat.getPlugin().getLogger().severe("The magic value " + key + " couldn't be found.");
        return 0;
    }
}

