/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.config.holders.mysql;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.config.ConfigurationTable;
import net.dynamicdev.anticheat.config.providers.Lang;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MySQLLangHolder
extends ConfigurationTable
implements InvocationHandler {
    private static final String TABLE = "lang";
    private HashMap<String, String> stringValues;
    private HashMap<String, List<String>> listValues;
    private FileConfiguration defaults;

    public MySQLLangHolder(Configuration config) {
        super(config, TABLE);
    }

    @Override
    public void open() {
        this.defaults = YamlConfiguration.loadConfiguration((InputStream)AntiCheat.getPlugin().getResource("lang.yml"));
        this.stringValues = new HashMap();
        this.listValues = new HashMap();
        String sqlCreate = "CREATE TABLE " + this.getFullTable() + "(" + "  `id` INT NOT NULL AUTO_INCREMENT," + "  `key` VARCHAR(45) NOT NULL," + "  `value` TEXT," + "  PRIMARY KEY (`id`));";
        String sqlPopulate = "INSERT INTO " + this.getFullTable() + " (`key`, `value`) " + "SELECT t.*" + "FROM (";
        Method[] methods = Lang.class.getMethods();
        for (int i = 1; i <= methods.length; ++i) {
            sqlPopulate = sqlPopulate + "(SELECT ? as `key`, ? as `value`)";
            if (i >= methods.length) continue;
            sqlPopulate = sqlPopulate + " UNION ALL ";
        }
        sqlPopulate = sqlPopulate + ") t;";
        String sqlLoad = "SELECT * FROM " + this.getFullTable();
        try {
            String value;
            String key;
            PreparedStatement insert = this.getConnection().prepareStatement(sqlPopulate);
            int strings = 1;
            for (int i = 1; i <= methods.length; ++i) {
                key = methods[i - 1].getName();
                value = this.defaults.getString(key);
                insert.setString(strings, key);
                insert.setString(++strings, value);
                ++strings;
            }
            if (!this.tableExists()) {
                this.getConnection().prepareStatement(sqlCreate).executeUpdate();
                insert.executeUpdate();
                this.getConnection().commit();
            }
            ResultSet set = this.getConnection().prepareStatement(sqlLoad).executeQuery();
            while (set.next()) {
                key = set.getString("key");
                value = set.getString("value");
                if (value.matches("^\\[.*\\]$")) {
                    this.listValues.put(key, this.getList(value));
                    continue;
                }
                this.stringValues.put(key, value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String key = method.getName();
        if (method.getReturnType() == List.class) {
            if (this.listValues.containsKey(key)) {
                return this.listValues.get(key);
            }
            if (this.defaults.getString(key) != null) {
                String value = this.defaults.getString(key);
                try {
                    PreparedStatement s = this.getConnection().prepareStatement("INSERT INTO " + this.getFullTable() + " (key, value) VALUES (?, ?)");
                    s.setString(1, key);
                    s.setString(2, value);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.reload();
                return this.getList(value);
            }
        } else {
            if (this.stringValues.containsKey(key)) {
                return this.stringValues.get(key);
            }
            if (this.defaults.getString(key) != null) {
                String value = this.defaults.getString(key);
                try {
                    PreparedStatement s = this.getConnection().prepareStatement("INSERT INTO " + this.getFullTable() + " (key, value) VALUES (?, ?)");
                    s.setString(1, key);
                    s.setString(2, value);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.reload();
                return value;
            }
        }
        AntiCheat.getPlugin().getLogger().severe("The lang value " + key + " couldn't be found.");
        return "Language error. See console for details.";
    }

    private List<String> getList(String value) {
        value = value.substring(1, value.length() - 1);
        ArrayList<String> list = new ArrayList<String>();
        for (String s : value.split(", ")) {
            list.add(s);
        }
        return list;
    }
}

