/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.config.holders.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.config.ConfigurationTable;
import net.dynamicdev.anticheat.config.providers.Groups;
import net.dynamicdev.anticheat.util.Group;

public class MySQLGroupsHolder
extends ConfigurationTable
implements Groups {
    private static final String TABLE = "groups";
    private List<Group> groups;
    private int highestLevel;

    public MySQLGroupsHolder(Configuration config) {
        super(config, TABLE);
    }

    @Override
    public void open() {
        this.highestLevel = 0;
        this.groups = new ArrayList<Group>();
        String sqlCreate = "CREATE TABLE " + this.getFullTable() + "(" + "  `id` INT NOT NULL AUTO_INCREMENT," + "  `name` VARCHAR(45) NOT NULL," + "  `level` INT NOT NULL," + "  `color` VARCHAR(45) NOT NULL," + "  `actions` VARCHAR(45) NOT NULL," + "  PRIMARY KEY (`id`));";
        String sqlPopulate = "INSERT INTO " + this.getFullTable() + "  SELECT t.*" + "  FROM (" + "    (SELECT 1 as id, 'Medium' as name, 20 as level, 'YELLOW' as color, 'WARN' as actions)" + "    UNION ALL " + "    (SELECT 2 as id, 'High' as name, 50 as level, 'RED' as color, 'KICK' as actions)" + "  ) t;";
        String sqlLoad = "SELECT * FROM " + this.getFullTable();
        try {
            if (!this.tableExists()) {
                this.getConnection().prepareStatement(sqlCreate).executeUpdate();
                this.getConnection().prepareStatement(sqlPopulate).executeUpdate();
                this.getConnection().commit();
            }
            ResultSet set = this.getConnection().prepareStatement(sqlLoad).executeQuery();
            while (set.next()) {
                String name = set.getString("name");
                int level = set.getInt("level");
                String color = set.getString("color");
                List<String> actions = Arrays.asList(set.getString("actions").split(","));
                this.groups.add(new Group(name, level, color, actions));
                if (level <= this.highestLevel) continue;
                this.highestLevel = level;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public int getHighestLevel() {
        return this.highestLevel;
    }
}

