/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.config;

import java.sql.Connection;
import java.sql.SQLException;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.util.enterprise.Database;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ConfigurationTable {
    private final String table;
    private final Configuration config;
    private Database database;
    private String prefix;
    private String serverName;

    public ConfigurationTable(Configuration config, String table) {
        this.config = config;
        this.table = table;
        this.load();
    }

    public void load() {
        this.database = this.config.getEnterprise().database;
        this.prefix = this.database.getPrefix();
        this.serverName = this.config.getEnterprise().serverName.getValue();
        this.open();
    }

    public void open() {
    }

    public void reload() {
        Bukkit.getScheduler().runTask((Plugin)AntiCheat.getPlugin(), new Runnable(){

            @Override
            public void run() {
                ConfigurationTable.this.load();
            }
        });
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getFullTable() {
        return this.prefix + this.table;
    }

    public boolean tableExists() {
        try {
            return this.getConnection().getMetaData().getTables(null, null, this.getFullTable(), null).next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public Connection getConnection() {
        return this.database.getConnection();
    }
}

