/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.config.yaml.CommentedConfiguration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationFile {
    private File rawFile;
    private String fileName;
    private CommentedConfiguration configFile;
    private FileConfiguration defaultConfigFile;
    private Configuration config;
    private AntiCheat plugin;
    private boolean saveDefault;
    protected boolean needsReload;

    public ConfigurationFile(AntiCheat plugin, Configuration config, String fileName) {
        this(plugin, config, fileName, true);
    }

    public ConfigurationFile(AntiCheat plugin, Configuration config, String fileName, boolean saveDefault) {
        this(plugin, config, fileName, saveDefault, new File(plugin.getDataFolder(), fileName));
    }

    public ConfigurationFile(AntiCheat plugin, Configuration config, String fileName, boolean saveDefault, File rawFile) {
        this.plugin = plugin;
        this.config = config;
        this.fileName = fileName;
        this.rawFile = rawFile;
        this.saveDefault = saveDefault;
        if (saveDefault) {
            this.defaultConfigFile = YamlConfiguration.loadConfiguration((InputStream)plugin.getResource(fileName));
        }
        this.load();
    }

    public void load() {
        if (!this.rawFile.exists()) {
            if (this.saveDefault) {
                this.plugin.saveResource(this.fileName, true);
            } else {
                if (!this.rawFile.getParentFile().exists()) {
                    this.rawFile.getParentFile().mkdir();
                }
                try {
                    this.rawFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.configFile = CommentedConfiguration.loadConfiguration(this.rawFile);
        this.open();
    }

    public void open() {
    }

    public void close() {
    }

    public void save() {
        this.close();
        try {
            this.configFile.save(this.rawFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        this.save();
        this.load();
    }

    public File getRawFile() {
        return this.rawFile;
    }

    public CommentedConfiguration getConfigFile() {
        return this.configFile;
    }

    public FileConfiguration getDefaultConfigFile() {
        return this.defaultConfigFile;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setNeedsReload(boolean reload) {
        this.needsReload = reload;
    }

    public boolean needsReload() {
        return this.needsReload;
    }

    public class ConfigValue<T> {
        private String path;
        private Object value = null;
        private boolean didLoadDefault;

        public ConfigValue(String path) {
            this(path, true);
        }

        public ConfigValue(String path, boolean loadDefault) {
            this.path = path;
            if (ConfigurationFile.this.getConfigFile().contains(path)) {
                this.value = ConfigurationFile.this.getConfigFile().get(path);
            } else if (loadDefault) {
                ConfigurationFile.this.getConfigFile().set(path, ConfigurationFile.this.getDefaultConfigFile().get(path));
                this.value = ConfigurationFile.this.getDefaultConfigFile().get(path);
                ConfigurationFile.this.getConfigFile().set(path, this.value);
                ConfigurationFile.this.save();
                this.didLoadDefault = true;
            }
        }

        public String getPath() {
            return this.path;
        }

        public T getValue() {
            return (T)this.value;
        }

        public T setValue(T value) {
            ConfigurationFile.this.getConfigFile().set(this.path, value);
            ConfigurationFile.this.save();
            return value;
        }

        public T getDefaultValue() {
            return (T)ConfigurationFile.this.getDefaultConfigFile().get(this.path);
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public boolean didLoadDefault() {
            return this.didLoadDefault;
        }
    }
}

