/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.config;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.config.ConfigurationFile;
import net.dynamicdev.anticheat.config.ConfigurationTable;
import net.dynamicdev.anticheat.config.files.Config;
import net.dynamicdev.anticheat.config.files.Enterprise;
import net.dynamicdev.anticheat.config.holders.mysql.MySQLGroupsHolder;
import net.dynamicdev.anticheat.config.holders.mysql.MySQLLangHolder;
import net.dynamicdev.anticheat.config.holders.mysql.MySQLLevelsHolder;
import net.dynamicdev.anticheat.config.holders.mysql.MySQLMagicHolder;
import net.dynamicdev.anticheat.config.holders.mysql.MySQLRulesHolder;
import net.dynamicdev.anticheat.config.holders.yaml.YamlGroupsHolder;
import net.dynamicdev.anticheat.config.holders.yaml.YamlLangHolder;
import net.dynamicdev.anticheat.config.holders.yaml.YamlLevelsHolder;
import net.dynamicdev.anticheat.config.holders.yaml.YamlMagicHolder;
import net.dynamicdev.anticheat.config.holders.yaml.YamlRulesHolder;
import net.dynamicdev.anticheat.config.providers.Groups;
import net.dynamicdev.anticheat.config.providers.Lang;
import net.dynamicdev.anticheat.config.providers.Levels;
import net.dynamicdev.anticheat.config.providers.Magic;
import net.dynamicdev.anticheat.config.providers.Rules;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import org.bukkit.configuration.file.YamlConfiguration;

public class Configuration {
    private AntiCheatManager manager;
    private Config config;
    private Enterprise enterprise;
    private Lang lang;
    private Magic magic;
    private Groups groups;
    private Levels levels;
    private Rules rules;
    private ArrayList<ConfigurationFile> flatfiles;
    private ArrayList<ConfigurationTable> dbfiles;

    public Configuration(AntiCheat plugin, AntiCheatManager manager) {
        InvocationHandler handler;
        this.removeOldFiles();
        this.manager = manager;
        this.config = new Config(plugin, this);
        plugin.setVerbose(this.config.verboseStartup.getValue());
        this.enterprise = new Enterprise(plugin, this);
        this.flatfiles = new ArrayList<ConfigurationFile>(){
            {
                this.add(Configuration.this.config);
                this.add(Configuration.this.enterprise);
            }
        };
        this.dbfiles = new ArrayList();
        if (this.config.enterprise.getValue().booleanValue() && this.enterprise.configGroups.getValue().booleanValue()) {
            this.groups = new MySQLGroupsHolder(this);
            this.dbfiles.add((MySQLGroupsHolder)this.groups);
        } else {
            this.groups = new YamlGroupsHolder(plugin, this);
            this.flatfiles.add((YamlGroupsHolder)this.groups);
        }
        if (this.config.enterprise.getValue().booleanValue() && this.enterprise.configRules.getValue().booleanValue()) {
            this.rules = new MySQLRulesHolder(this);
            this.dbfiles.add((MySQLRulesHolder)this.rules);
        } else {
            this.rules = new YamlRulesHolder(plugin, this);
            this.flatfiles.add((YamlRulesHolder)this.rules);
        }
        if (this.config.enterprise.getValue().booleanValue() && this.enterprise.configMagic.getValue().booleanValue()) {
            handler = new MySQLMagicHolder(this);
            this.magic = (Magic)Proxy.newProxyInstance(Magic.class.getClassLoader(), new Class[]{Magic.class}, handler);
            this.dbfiles.add((MySQLMagicHolder)handler);
        } else {
            handler = new YamlMagicHolder(plugin, this);
            this.magic = (Magic)Proxy.newProxyInstance(Magic.class.getClassLoader(), new Class[]{Magic.class}, handler);
            this.flatfiles.add((ConfigurationFile)((Object)handler));
        }
        if (this.config.enterprise.getValue().booleanValue() && this.enterprise.configLang.getValue().booleanValue()) {
            handler = new MySQLLangHolder(this);
            this.lang = (Lang)Proxy.newProxyInstance(Lang.class.getClassLoader(), new Class[]{Lang.class}, handler);
            this.dbfiles.add((MySQLLangHolder)handler);
        } else {
            handler = new YamlLangHolder(plugin, this);
            this.lang = (Lang)Proxy.newProxyInstance(Lang.class.getClassLoader(), new Class[]{Lang.class}, handler);
            this.flatfiles.add((YamlLangHolder)handler);
        }
        if (this.config.enterprise.getValue().booleanValue() && this.enterprise.syncLevels.getValue().booleanValue()) {
            this.levels = new MySQLLevelsHolder(this);
            this.dbfiles.add((MySQLLevelsHolder)this.levels);
        } else {
            this.levels = new YamlLevelsHolder(plugin, this);
            this.flatfiles.add((YamlLevelsHolder)this.levels);
        }
        for (ConfigurationFile file : this.flatfiles) {
            file.save();
            this.checkReload(file);
        }
    }

    public void load() {
        for (ConfigurationFile file : this.flatfiles) {
            file.load();
            this.checkReload(file);
        }
        for (ConfigurationTable table : this.dbfiles) {
            table.load();
        }
        if (this.manager.getBackend() != null) {
            this.manager.getBackend().updateConfig(this);
        }
    }

    private void checkReload(ConfigurationFile file) {
        if (file.needsReload()) {
            file.reload();
            file.setNeedsReload(false);
        }
    }

    private void removeOldFiles() {
        File eventsFile;
        ArrayList<String> removed = new ArrayList<String>();
        File configFile = new File(AntiCheat.getPlugin().getDataFolder(), "config.yml");
        if (configFile.exists() && YamlConfiguration.loadConfiguration((File)configFile).getString("System.Auto update") != null) {
            configFile.renameTo(new File(AntiCheat.getPlugin().getDataFolder(), "config.old"));
            removed.add("config.yml has been renamed to config.old and replaced with the new config.yml");
        }
        if ((eventsFile = new File(AntiCheat.getPlugin().getDataFolder(), "events.yml")).exists()) {
            eventsFile.renameTo(new File(AntiCheat.getPlugin().getDataFolder(), "events.old"));
            removed.add("events.yml has been renamed to events.old and replaced with groups.yml and rules.yml");
        }
        if (removed.size() > 0) {
            AntiCheat.getPlugin().getLogger().info("You are upgrading from an old version of AntiCheat. Due to configuration changes, the following files have been modified:");
            for (String s : removed) {
                AntiCheat.getPlugin().getLogger().info(s);
            }
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public Groups getGroups() {
        return this.groups;
    }

    public Rules getRules() {
        return this.rules;
    }

    public Lang getLang() {
        return this.lang;
    }

    public Enterprise getEnterprise() {
        return this.enterprise;
    }

    public Levels getLevels() {
        return this.levels;
    }

    public Magic getMagic() {
        return this.magic;
    }
}

