/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.command.executors;

import net.dynamicdev.anticheat.command.CommandBase;
import net.dynamicdev.anticheat.config.ConfigurationFile;
import net.dynamicdev.anticheat.util.Permission;
import org.bukkit.command.CommandSender;

public class CommandLog
extends CommandBase {
    private static final String NAME = "AntiCheat Logging";
    private static final String COMMAND = "log";
    private static final String USAGE = "anticheat log [file/console] [on/off]";
    private static final Permission PERMISSION = Permission.SYSTEM_LOG;
    private static final String[] HELP = new String[]{GRAY + "Use: " + AQUA + "/anticheat log console on" + GRAY + " to enable console logging", GRAY + "Use: " + AQUA + "/anticheat log file off" + GRAY + " to disable file logging"};

    public CommandLog() {
        super(NAME, COMMAND, USAGE, HELP, PERMISSION);
    }

    @Override
    protected void execute(CommandSender cs, String[] args) {
        if (args.length == 2) {
            String strValue;
            boolean newValue;
            String name;
            ConfigurationFile.ConfigValue<Boolean> value;
            if (args[0].equalsIgnoreCase("file")) {
                value = CommandLog.CONFIG.getConfig().logToFile;
                name = "File logging";
            } else if (args[0].equalsIgnoreCase("console")) {
                value = CommandLog.CONFIG.getConfig().logToConsole;
                name = "Console logging";
            } else {
                this.sendHelp(cs);
                return;
            }
            if (args[1].equalsIgnoreCase("on") || args[1].equalsIgnoreCase("enable")) {
                newValue = true;
            } else if (args[1].equalsIgnoreCase("off") || args[1].equalsIgnoreCase("disable")) {
                newValue = false;
            } else {
                this.sendHelp(cs);
                return;
            }
            String string = strValue = newValue ? " enabled" : " disabled";
            if (value.getValue() == newValue) {
                cs.sendMessage(GREEN + name + " is already " + strValue + "!");
            } else {
                value.setValue(newValue);
                cs.sendMessage(GREEN + name + strValue + ".");
                CONFIG.getConfig().reload();
            }
        } else {
            this.sendHelp(cs);
        }
    }
}

