/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.command.executors;

import java.util.List;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.command.CommandBase;
import net.dynamicdev.anticheat.util.Permission;
import org.bukkit.command.CommandSender;

public class CommandCheck
extends CommandBase {
    private static final String NAME = "AntiCheat Check Management";
    private static final String COMMAND = "check";
    private static final String USAGE = "anticheat check [check] [on/off]";
    private static final Permission PERMISSION = Permission.SYSTEM_CHECK;
    private static final String[] HELP = new String[3];

    public CommandCheck() {
        super(NAME, COMMAND, USAGE, HELP, PERMISSION);
    }

    @Override
    protected void execute(CommandSender cs, String[] args) {
        if (args.length == 2) {
            for (CheckType type : CheckType.values()) {
                String strValue;
                boolean newValue;
                if (!type.toString().equalsIgnoreCase(args[0]) && !type.toString().replaceAll("_", "").equalsIgnoreCase(args[0])) continue;
                boolean value = CHECK_MANAGER.isActive(type);
                if (args[1].equalsIgnoreCase("on") || args[1].equalsIgnoreCase("enable")) {
                    newValue = true;
                } else if (args[1].equalsIgnoreCase("off") || args[1].equalsIgnoreCase("disable")) {
                    newValue = false;
                } else {
                    this.sendHelp(cs);
                    return;
                }
                String string = strValue = newValue ? " activated" : " deactivated";
                if (value == newValue) {
                    cs.sendMessage(GREEN + type.toString() + " is already" + strValue + "!");
                } else {
                    if (newValue) {
                        CHECK_MANAGER.activateCheck(type, cs.getName());
                        List<String> checks = CommandCheck.CONFIG.getConfig().disabledChecks.getValue();
                        if (checks.contains(type.toString())) {
                            checks.remove(type.toString());
                            CommandCheck.CONFIG.getConfig().disabledChecks.setValue(checks);
                        }
                    } else {
                        CHECK_MANAGER.deactivateCheck(type, cs.getName());
                        List<String> checks = CommandCheck.CONFIG.getConfig().disabledChecks.getValue();
                        checks.add(type.toString());
                        CommandCheck.CONFIG.getConfig().disabledChecks.setValue(checks);
                    }
                    cs.sendMessage(GREEN + type.toString() + strValue + ".");
                }
                return;
            }
        }
        this.sendHelp(cs);
    }

    static {
        CommandCheck.HELP[0] = GRAY + "Use: " + AQUA + "/anticheat check [check] on" + GRAY + " to enable a check";
        CommandCheck.HELP[1] = GRAY + "Use: " + AQUA + "/anticheat check [check] off" + GRAY + " to disable a check";
        StringBuilder builder = new StringBuilder();
        builder.append(GRAY + "Checks: ");
        for (int i = 0; i < CheckType.values().length; ++i) {
            builder.append((Object)CheckType.values()[i]);
            if (i >= CheckType.values().length - 1) continue;
            builder.append(", ");
        }
        CommandCheck.HELP[2] = builder.toString();
    }
}

