/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.command;

import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.manage.CheckManager;
import net.dynamicdev.anticheat.manage.UserManager;
import net.dynamicdev.anticheat.util.Permission;
import net.dynamicdev.anticheat.xray.XRayTracker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandBase {
    public static final Configuration CONFIG = AntiCheat.getManager().getConfiguration();
    public static final UserManager USER_MANAGER = AntiCheat.getManager().getUserManager();
    public static final CheckManager CHECK_MANAGER = AntiCheat.getManager().getCheckManager();
    public static final XRayTracker XRAY_TRACKER = AntiCheat.getManager().getXRayTracker();
    public static final ChatColor RED = ChatColor.RED;
    public static final ChatColor YELLOW = ChatColor.YELLOW;
    public static final ChatColor GREEN = ChatColor.GREEN;
    public static final ChatColor WHITE = ChatColor.WHITE;
    public static final ChatColor GRAY = ChatColor.GRAY;
    public static final ChatColor GOLD = ChatColor.GOLD;
    public static final ChatColor AQUA = ChatColor.AQUA;
    public static final Server SERVER = Bukkit.getServer();
    public static final String PERMISSIONS_ERROR = RED + "Insufficient Permissions.";
    public static final String MENU_END = "-----------------------------------------------------";
    private final String name;
    private final String command;
    private final String usage;
    private final String[] help;
    private final Permission permission;

    public CommandBase(String name, String command, String usage, String[] help, Permission permission) {
        this.name = name;
        this.command = command;
        this.usage = usage;
        this.help = help;
        this.permission = permission;
    }

    public void run(CommandSender cs, String[] args) {
        if (this.permission.get(cs)) {
            this.execute(cs, args);
        } else {
            cs.sendMessage(PERMISSIONS_ERROR + " (" + WHITE + this.permission.toString() + RED + ")");
        }
    }

    protected void execute(CommandSender cs, String[] args) {
    }

    public void sendHelp(CommandSender cs) {
        cs.sendMessage(GREEN + "== " + GRAY + this.getName() + GREEN + " ==");
        cs.sendMessage(GREEN + "Usage: " + GRAY + (cs instanceof Player ? "/" : "") + this.getUsage());
        cs.sendMessage(GREEN + "Permission: " + GRAY + this.getPermission().toString());
        for (String string : this.getHelp()) {
            cs.sendMessage(string);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCommand() {
        return this.command;
    }

    public String getUsage() {
        return this.usage;
    }

    public String[] getHelp() {
        return this.help;
    }

    public Permission getPermission() {
        return this.permission;
    }
}

