/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.check.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.AntiCheatCheck;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import net.dynamicdev.anticheat.util.Distance;
import net.dynamicdev.anticheat.util.SimpleLocation;
import net.dynamicdev.anticheat.util.TimedLocation;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class MovementCheck
extends AntiCheatCheck {
    private List<String> isInWater = new ArrayList<String>();
    private List<String> isInWaterCache = new ArrayList<String>();
    private List<String> isAscending = new ArrayList<String>();
    private Map<String, Integer> ascensionCount = new HashMap<String, Integer>();
    private Map<String, Double> blocksOverFlight = new HashMap<String, Double>();
    private Map<String, Integer> nofallViolation = new HashMap<String, Integer>();
    private Map<String, Integer> speedViolation = new HashMap<String, Integer>();
    private Map<String, Integer> yAxisViolations = new HashMap<String, Integer>();
    private Map<String, Long> yAxisLastViolation = new HashMap<String, Long>();
    private Map<String, Double> lastYcoord = new HashMap<String, Double>();
    private Map<String, Long> lastYtime = new HashMap<String, Long>();
    private Map<String, Integer> waterAscensionViolation = new HashMap<String, Integer>();
    private Map<String, Integer> waterSpeedViolation = new HashMap<String, Integer>();
    private Map<String, Long> velocitized = new HashMap<String, Long>();
    private Map<String, Integer> steps = new HashMap<String, Integer>();
    private Map<String, Long> stepTime = new HashMap<String, Long>();
    private Map<String, Long> lastFallPacket = new HashMap<String, Long>();
    private Map<String, Integer> hoverTicks = new HashMap<String, Integer>();
    private Map<String, Integer> velocityFail = new HashMap<String, Integer>();
    private Map<String, TimedLocation> timedLoc = new HashMap<String, TimedLocation>();
    private Map<String, Integer> verticalCount = new HashMap<String, Integer>();
    private Map<String, Boolean> canMoveVert = new HashMap<String, Boolean>();
    private Map<String, Long> timeInWater = new HashMap<String, Long>();
    private Map<String, Integer> velocitytrack = new HashMap<String, Integer>();
    private Map<String, Long> movingExempt = new HashMap<String, Long>();
    private Map<String, Long> sneakExempt = new HashMap<String, Long>();
    private Map<String, Integer> timerBuffer = new HashMap<String, Integer>();
    private Map<String, Integer> glideBuffer = new HashMap<String, Integer>();
    private Map<String, Double> lastYDelta = new HashMap<String, Double>();
    private Map<String, SimpleLocation> lastTickLocation = new HashMap<String, SimpleLocation>();
    private static final double TIME_SECOND = 1.0;
    private static final double MIN_Y_DELTA = 0.3;

    public MovementCheck(AntiCheatManager instance) {
        super(instance);
    }

    public Map getMovingExempt() {
        return this.movingExempt;
    }

    public Map getSneakExempt() {
        return this.sneakExempt;
    }

    public boolean hasJumpPotion(Player player) {
        return player.hasPotionEffect(PotionEffectType.JUMP);
    }

    public boolean hasSpeedPotion(Player player) {
        return player.hasPotionEffect(PotionEffectType.SPEED);
    }

    public boolean isAscending(Player player) {
        return this.isAscending.contains(player.getName());
    }

    public void logTeleport(Player player) {
        this.nofallViolation.remove(player.getName());
        this.blocksOverFlight.remove(player.getName());
        this.yAxisViolations.remove(player.getName());
        this.yAxisLastViolation.remove(player.getName());
        this.lastYcoord.remove(player.getName());
        this.lastYtime.remove(player.getName());
        this.lastTickLocation.put(player.getName(), new SimpleLocation(player.getLocation()));
        this.timedLoc.put(player.getName(), new TimedLocation(player.getLocation(), System.currentTimeMillis()));
    }

    public boolean isHoveringOverWaterAfterViolation(Player player) {
        return this.waterSpeedViolation.containsKey(player.getName()) && this.waterSpeedViolation.get(player.getName()) >= this.magic.WATER_SPEED_VIOLATION_MAX() && Utilities.isHoveringOverWater(player.getLocation());
    }

    public void logVelocity(Player player) {
        this.velocitized.put(player.getName(), System.currentTimeMillis());
    }

    public boolean justVelocity(Player player) {
        return this.velocitized.containsKey(player.getName()) ? System.currentTimeMillis() - this.velocitized.get(player.getName()) < (long)this.magic.VELOCITY_CHECKTIME() : false;
    }

    public boolean extendVelocityTime(final Player player) {
        if (this.velocitytrack.containsKey(player.getName())) {
            this.velocitytrack.put(player.getName(), this.velocitytrack.get(player.getName()) + 1);
            if (this.velocitytrack.get(player.getName()) > this.magic.VELOCITY_MAXTIMES()) {
                this.velocitized.put(player.getName(), System.currentTimeMillis() + (long)this.magic.VELOCITY_PREVENT());
                this.manager.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.manager.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        MovementCheck.this.velocitytrack.put(player.getName(), 0);
                    }
                }, (long)this.magic.VELOCITY_SCHETIME() * 20L);
                return true;
            }
        } else {
            this.velocitytrack.put(player.getName(), 0);
        }
        return false;
    }

    public CheckResult checkFreeze(Player player, double from, double to) {
        return PASS;
    }

    public CheckResult checkSpider(Player player, double y) {
        String name = player.getName();
        if (!this.verticalCount.containsKey(name)) {
            this.verticalCount.put(name, 0);
        }
        if (y <= this.magic.LADDER_Y_MAX() && y >= this.magic.LADDER_Y_MIN() && !Utilities.isClimbableBlock(player.getLocation().getBlock())) {
            this.verticalCount.put(name, this.verticalCount.get(name) + 1);
            if (this.verticalCount.get(name) > this.magic.Y_MAXVIOLATIONS()) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to climb a non-ladder (" + player.getLocation().getBlock().getType() + ")");
            }
        }
        this.verticalCount.put(name, this.verticalCount.get(name) - 1);
        return PASS;
    }

    public CheckResult checkYSpeed(Player player, double y) {
        double multiPlier;
        double d = multiPlier = player.getEyeLocation().getBlock().getType() == Material.WEB ? this.magic.XZ_SPEED_WEB_MULTIPLIER() : 1.0;
        if (!(AntiCheat.getManager().getBackend().isMovingExempt(player) || player.isInsideVehicle() || player.isSleeping() || !(y > this.magic.Y_SPEED_MAX() * multiPlier) || this.isDoing(player, this.velocitized, this.magic.VELOCITY_TIME()) || player.hasPotionEffect(PotionEffectType.JUMP))) {
            return new CheckResult(CheckResult.Result.FAILED, player.getName() + "'s y speed was too high (speed=" + y + ", max=" + this.magic.Y_SPEED_MAX() + ")");
        }
        return PASS;
    }

    public CheckResult checkNoFall(Player player, double y) {
        String name = player.getName();
        if (!(player.getGameMode() == GameMode.CREATIVE || player.isInsideVehicle() || player.isSleeping() || AntiCheat.getManager().getBackend().isMovingExempt(player) || AntiCheat.getManager().getBackend().getBlockCheck().justPlaced(player) || Utilities.isInWater(player) || Utilities.isInWeb(player))) {
            if (player.getFallDistance() == 0.0f) {
                if (this.nofallViolation.get(name) == null) {
                    this.nofallViolation.put(name, 1);
                } else {
                    this.nofallViolation.put(name, this.nofallViolation.get(player.getName()) + 1);
                }
                int i = this.nofallViolation.get(name);
                if (i >= this.magic.NOFALL_LIMIT()) {
                    this.nofallViolation.put(player.getName(), 1);
                    return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to avoid fall damage (fall distance = 0 " + i + " times in a row, max=" + this.magic.NOFALL_LIMIT() + ")");
                }
                return PASS;
            }
            this.nofallViolation.put(name, 0);
            return PASS;
        }
        return PASS;
    }

    public CheckResult checkVelocitized(Player player, Distance theDistance) {
        String name = player.getName();
        if (!this.velocityFail.containsKey(name)) {
            this.velocityFail.put(name, 0);
        }
        if (!AntiCheat.getManager().getBackend().isMovingExempt(player) && player.getVehicle() == null && this.justVelocity(player)) {
            double multi;
            double d = multi = player.hasPotionEffect(PotionEffectType.SLOW) ? 0.75 : 1.0;
            if (theDistance.getXDifference() < this.magic.VELOCITY_MIN_DISTANCE() * multi || theDistance.getZDifference() < this.magic.VELOCITY_MIN_DISTANCE() * multi) {
                this.velocityFail.put(name, this.velocityFail.get(name) + 1);
                if ((double)this.velocityFail.get(name).intValue() > this.magic.VELOCITY_DISTANCE_COUNT()) {
                    // empty if block
                }
            } else {
                this.velocityFail.put(name, 0);
            }
        }
        return PASS;
    }

    public CheckResult checkXZSpeed(Player player, double x, double z) {
        if (!this.speedViolation.containsKey(player.getName())) {
            this.speedViolation.put(player.getName(), 1);
        }
        if (!this.lastTickLocation.containsKey(player.getName())) {
            this.lastTickLocation.put(player.getName(), new SimpleLocation(player.getLocation()));
        }
        SimpleLocation lastLocation = this.lastTickLocation.get(player.getName());
        SimpleLocation currentLocation = new SimpleLocation(player.getLocation());
        this.lastTickLocation.put(player.getName(), new SimpleLocation(player.getLocation()));
        if (!AntiCheat.getManager().getBackend().isSpeedExempt(player) && player.getVehicle() == null) {
            float speed;
            String reason = "";
            double max = this.magic.XZ_SPEED_MAX();
            if (player.getLocation().getBlock().getType() == Material.SOUL_SAND) {
                if (player.isSprinting()) {
                    reason = "on soulsand while sprinting ";
                    max = this.magic.XZ_SPEED_MAX_SOULSAND_SPRINT();
                } else if (player.hasPotionEffect(PotionEffectType.SPEED)) {
                    reason = "on soulsand with speed potion ";
                    max = this.magic.XZ_SPEED_MAX_SOULSAND_POTION();
                } else {
                    reason = "on soulsand ";
                    max = this.magic.XZ_SPEED_MAX_SOULSAND();
                }
            } else if (player.isFlying()) {
                reason = "while flying ";
                max = this.magic.XZ_SPEED_MAX_FLY();
            } else if (player.hasPotionEffect(PotionEffectType.SPEED)) {
                if (player.isSprinting()) {
                    reason = "with speed potion while sprinting ";
                    max = this.magic.XZ_SPEED_MAX_POTION_SPRINT();
                } else {
                    reason = "with speed potion ";
                    max = this.magic.XZ_SPEED_MAX_POTION();
                }
            } else if (player.isSprinting()) {
                reason = "while sprinting ";
                max = this.magic.XZ_SPEED_MAX_SPRINT();
            }
            if (!this.timeInWater.containsKey(player.getName())) {
                this.timeInWater.put(player.getName(), System.currentTimeMillis());
            }
            double multiPerLevel = 1.55;
            int level = Utilities.getLevelForEnchantment(player, "DEPTH_STRIDER");
            if (level != -1) {
                max *= (double)level * multiPerLevel;
            }
            max += (speed = player.getWalkSpeed()) > 0.0f ? (double)(player.getWalkSpeed() - 0.2f) : 0.0;
            boolean isEating = false;
            if (player.getLocation().getBlock().getType() == Material.ICE) {
                max *= this.magic.XZ_SPEED_ICE_MULTIPLIER();
            } else if ((Utilities.isInWeb(player) || player.isBlocking() || isEating) && player.getGameMode() != GameMode.CREATIVE && !player.isFlying() && player.getLocation().getBlock().getType() != Material.SOUL_SAND) {
                max *= this.magic.XZ_SPEED_WEB_MULTIPLIER();
            }
            if (x > max || z > max || Utilities.getHorizontalDistance(lastLocation, currentLocation) > this.magic.XZ_TICK_MAX()) {
                int num = this.increment(player, this.speedViolation, this.magic.SPEED_MAX());
                if (num >= this.magic.SPEED_MAX()) {
                    return new CheckResult(CheckResult.Result.FAILED, player.getName() + "'s speed was too high " + reason + num + " times in a row (max=" + this.magic.SPEED_MAX() + ", speed=" + (x > z ? x : z) + ", max speed=" + max + ")");
                }
            } else if (this.speedViolation.get(player.getName()) > 1) {
                this.speedViolation.put(player.getName(), this.speedViolation.get(player.getName()) - 1);
            }
        }
        return PASS;
    }

    public CheckResult checkSneak(Player player, double x, double z) {
        if (player.isSneaking() && !player.isFlying() && !AntiCheat.getManager().getBackend().isSneakExempt(player) && !player.isInsideVehicle()) {
            double i;
            double d = x > this.magic.XZ_SPEED_MAX_SNEAK() ? x : (i = z > this.magic.XZ_SPEED_MAX_SNEAK() ? z : -1.0);
            if (i != -1.0) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " was sneaking too fast (speed=" + i + ", max=" + this.magic.XZ_SPEED_MAX_SNEAK() + ")");
            }
            return PASS;
        }
        return PASS;
    }

    public CheckResult checkSprintHungry(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        if (event.isSprinting() && player.getGameMode() != GameMode.CREATIVE && player.getFoodLevel() <= this.magic.SPRINT_FOOD_MIN()) {
            return new CheckResult(CheckResult.Result.FAILED, player.getName() + " sprinted while hungry (food=" + player.getFoodLevel() + ", min=" + this.magic.SPRINT_FOOD_MIN() + ")");
        }
        return PASS;
    }

    public CheckResult checkSprintStill(Player player, Location from, Location to) {
        return PASS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CheckResult checkWaterWalk(Player player, double x, double y, double z) {
        Block block = player.getLocation().getBlock();
        if (player.getVehicle() != null) return PASS;
        if (player.isFlying()) return PASS;
        if (block.isLiquid()) {
            boolean b;
            if (!this.isInWater.contains(player.getName())) {
                this.isInWater.add(player.getName());
                return PASS;
            }
            if (!this.isInWaterCache.contains(player.getName())) {
                this.isInWaterCache.add(player.getName());
                return PASS;
            }
            if (!player.getNearbyEntities(1.0, 1.0, 1.0).isEmpty()) return PASS;
            if (!Utilities.sprintFly(player)) {
                b = x > this.magic.XZ_SPEED_MAX_WATER() || z > this.magic.XZ_SPEED_MAX_WATER();
            } else {
                boolean bl = b = x > this.magic.XZ_SPEED_MAX_WATER_SPRINT() || z > this.magic.XZ_SPEED_MAX_WATER_SPRINT();
            }
            if (!b && !Utilities.isFullyInWater(player.getLocation()) && Utilities.isHoveringOverWater(player.getLocation(), 1) && y == 0.0 && !block.getType().equals((Object)Material.WATER_LILY)) {
                b = true;
            }
            if (!b) return PASS;
            if (!this.waterSpeedViolation.containsKey(player.getName())) {
                this.waterSpeedViolation.put(player.getName(), 1);
                return PASS;
            }
            int v = this.waterSpeedViolation.get(player.getName());
            if (v >= this.magic.WATER_SPEED_VIOLATION_MAX()) {
                this.waterSpeedViolation.put(player.getName(), 0);
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " stood on water " + v + " times (can't stand on " + block.getType() + " or " + block.getRelative(BlockFace.DOWN).getType() + ")");
            }
            this.waterSpeedViolation.put(player.getName(), v + 1);
            return PASS;
        }
        if (block.getRelative(BlockFace.DOWN).isLiquid() && this.isAscending(player) && Utilities.cantStandAt(block) && Utilities.cantStandAt(block.getRelative(BlockFace.DOWN))) {
            if (!this.waterAscensionViolation.containsKey(player.getName())) {
                this.waterAscensionViolation.put(player.getName(), this.waterAscensionViolation.get(player.getName()) - 1);
                return PASS;
            }
            int v = this.waterAscensionViolation.get(player.getName());
            if (v >= this.magic.WATER_ASCENSION_VIOLATION_MAX()) {
                this.waterAscensionViolation.put(player.getName(), 0);
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " stood on water " + v + " times (can't stand on " + block.getType() + " or " + block.getRelative(BlockFace.DOWN).getType() + ")");
            }
            this.waterAscensionViolation.put(player.getName(), v + 1);
            return PASS;
        }
        this.isInWater.remove(player.getName());
        this.isInWaterCache.remove(player.getName());
        return PASS;
    }

    public CheckResult checkNoclip(Player player) {
        Block block = player.getEyeLocation().getBlock();
        Block otherBlock = player.getLocation().getBlock();
        if (!Utilities.canStandWithin(block) && !Utilities.canStandWithin(otherBlock) || !Utilities.canStandWithin(block) && !AntiCheat.getManager().getBackend().isMovingExempt(player)) {
            return new CheckResult(CheckResult.Result.FAILED, player.getName() + " attempted to pass through a solid block.");
        }
        return PASS;
    }

    public CheckResult checkVClip(Player player, Distance distance) {
        double from = Math.round(distance.fromY());
        double to = Math.round(distance.toY());
        if (player.isInsideVehicle() || from == to || from < to || Math.round(distance.getYDifference()) < 2L) {
            return PASS;
        }
        int i = 0;
        while ((long)i < Math.round(distance.getYDifference()) + 1L) {
            Block block = new Location(player.getWorld(), player.getLocation().getX(), to + (double)i, player.getLocation().getZ()).getBlock();
            if (block.getType() != Material.AIR && block.getType().isSolid()) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to move through a solid block", (int)from + 3);
            }
            ++i;
        }
        return PASS;
    }

    public CheckResult checkYAxis(Player player, Distance distance) {
        String name = player.getName();
        if (!this.canMoveVert.containsKey(name)) {
            this.canMoveVert.put(name, true);
        }
        if (distance.getYDifference() > (double)this.magic.TELEPORT_MIN() || distance.getYDifference() < 0.0) {
            return PASS;
        }
        if (!(AntiCheat.getManager().getBackend().isMovingExempt(player) || Utilities.isClimbableBlock(player.getLocation().getBlock()) || Utilities.isClimbableBlock(player.getLocation().add(0.0, -1.0, 0.0).getBlock()) || player.isInsideVehicle() || Utilities.isInWater(player) || this.hasJumpPotion(player))) {
            double y1 = player.getLocation().getY();
            double lastDelta = distance.getYActual();
            if (player.getLocation().getBlock().getType() != Material.AIR || player.isOnGround()) {
                this.canMoveVert.put(name, true);
            } else if (this.canMoveVert.get(name).booleanValue()) {
                if (lastDelta > 0.0) {
                    this.canMoveVert.put(name, false);
                }
            } else if (lastDelta < 0.0) {
                if (!this.yAxisViolations.containsKey(name)) {
                    this.yAxisViolations.put(name, 0);
                }
                this.yAxisViolations.put(name, this.yAxisViolations.get(name) + 1);
                if (this.yAxisViolations.get(name) > this.magic.Y_MAXVIOLATIONS()) {
                    Location g = player.getLocation();
                    if (!this.silentMode()) {
                        g.setY(this.lastYcoord.get(name).doubleValue());
                        this.sendFormattedMessage(player, "Fly hacking on the y-axis detected.");
                        if (g.getBlock().getType() == Material.AIR) {
                            player.teleport(g);
                        }
                    }
                    return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to ascend on the y-axis without hitting the ground.");
                }
            }
            if (!(this.lastYcoord.containsKey(name) && this.lastYtime.containsKey(name) && this.yAxisLastViolation.containsKey(name) && this.yAxisLastViolation.containsKey(name))) {
                this.lastYcoord.put(name, y1);
                this.yAxisViolations.put(name, 0);
                this.yAxisLastViolation.put(name, 0L);
                this.lastYtime.put(name, System.currentTimeMillis());
            } else {
                boolean overAir;
                if (!this.hoverTicks.containsKey(name)) {
                    this.hoverTicks.put(name, 0);
                }
                boolean bl = overAir = Utilities.cantStandAtBetter(player.getLocation().getBlock()) && !player.isSneaking();
                if (Math.abs(y1 - this.lastYcoord.get(name)) <= this.magic.Y_HOVER_BUFFER() * 0.75 && overAir) {
                    this.hoverTicks.put(name, this.hoverTicks.get(name) + 1);
                    if ((double)this.hoverTicks.get(name).intValue() > this.magic.Y_HOVER_TIME()) {
                        Location g = player.getLocation();
                        if (!this.silentMode()) {
                            g.setY(this.lastYcoord.get(name).doubleValue());
                            this.sendFormattedMessage(player, "Fly hacking on the y-axis detected.");
                            if (g.getBlock().getType() == Material.AIR) {
                                player.teleport(g);
                            }
                        }
                        return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to fly (hover) on y-axis " + this.hoverTicks.get(name) + " times (max =" + this.magic.Y_HOVER_TIME() + ")");
                    }
                } else {
                    this.hoverTicks.put(name, 0);
                }
                if (y1 > this.lastYcoord.get(name) && this.yAxisViolations.get(name) > this.magic.Y_MAXVIOLATIONS() && System.currentTimeMillis() - this.yAxisLastViolation.get(name) < (long)this.magic.Y_MAXVIOTIME()) {
                    Location g = player.getLocation();
                    this.yAxisViolations.put(name, this.yAxisViolations.get(name) + 1);
                    this.yAxisLastViolation.put(name, System.currentTimeMillis());
                    if (!this.silentMode()) {
                        g.setY(this.lastYcoord.get(name).doubleValue());
                        this.sendFormattedMessage(player, "Fly hacking on the y-axis detected.  Please wait 5 seconds to prevent getting damage.");
                        if (g.getBlock().getType() == Material.AIR) {
                            player.teleport(g);
                        }
                    }
                    return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to fly on y-axis " + this.yAxisViolations.get(name) + " times (max =" + this.magic.Y_MAXVIOLATIONS() + ")");
                }
                if (this.yAxisViolations.get(name) > this.magic.Y_MAXVIOLATIONS() && System.currentTimeMillis() - this.yAxisLastViolation.get(name) > (long)this.magic.Y_MAXVIOTIME()) {
                    this.yAxisViolations.put(name, this.yAxisViolations.get(name) - 1);
                    this.yAxisLastViolation.put(name, 0L);
                }
                long i = System.currentTimeMillis() - this.lastYtime.get(name);
                double diff = this.magic.Y_MAXDIFF() + (Utilities.isStair(player.getLocation().add(0.0, -1.0, 0.0).getBlock()) ? 0.5 : 0.0);
                if (y1 - this.lastYcoord.get(name) > diff && i < (long)this.magic.Y_TIME()) {
                    if (player != null) {
                        Location g = player.getLocation();
                        this.yAxisViolations.put(name, this.yAxisViolations.get(name) + 1);
                        this.yAxisLastViolation.put(name, System.currentTimeMillis());
                        if (!this.silentMode()) {
                            g.setY(this.lastYcoord.get(name).doubleValue());
                            if (g.getBlock().getType() == Material.AIR) {
                                player.teleport(g);
                            }
                        }
                    }
                    return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to fly on y-axis in " + i + " ms (min =" + this.magic.Y_TIME() + ")");
                }
                if (y1 - this.lastYcoord.get(name) > this.magic.Y_MAXDIFF() + 1.0 || System.currentTimeMillis() - this.lastYtime.get(name) > (long)this.magic.Y_TIME()) {
                    this.lastYtime.put(name, System.currentTimeMillis());
                    this.lastYcoord.put(name, y1);
                }
            }
        }
        return PASS;
    }

    public CheckResult checkTimer(Player player) {
        if (player == null || player.getName() == null) {
            return PASS;
        }
        String name = player.getName();
        if (!this.stepTime.containsKey(name)) {
            this.stepTime.put(name, System.currentTimeMillis());
        }
        if (!this.timerBuffer.containsKey(name)) {
            this.timerBuffer.put(name, this.magic.TIMER_STEP_CHECK() * 3);
        }
        this.timerBuffer.put(name, this.timerBuffer.get(name) - 1);
        if (!AntiCheat.getManager().getBackend().isMovingExempt(player)) {
            if (this.timerBuffer.get(name) < 0) {
                if (!this.silentMode()) {
                    this.sendFormattedMessage(player, "Modification of game timer detected. Please stand still for a bit.");
                }
                this.incrementTimerBuffer(name);
                return new CheckResult(CheckResult.Result.FAILED, name + " attempted to send packets too fast!");
            }
            this.incrementTimerBuffer(name);
        }
        return PASS;
    }

    private void incrementTimerBuffer(String name) {
        double timeSince = (System.currentTimeMillis() - this.stepTime.get(name)) / 1000L;
        if (timeSince > 1.0) {
            double allowedPackets = timeSince * (double)this.magic.TIMER_TIMEMIN();
            if (this.timerBuffer.get(name) > 65) {
                this.timerBuffer.put(name, 65);
            } else {
                this.timerBuffer.put(name, (int)((double)this.timerBuffer.get(name).intValue() + allowedPackets));
            }
            this.stepTime.put(name, System.currentTimeMillis());
        }
    }

    public CheckResult checkGlide(Player player) {
        double currentY;
        double math;
        String name = player.getName();
        if (!this.glideBuffer.containsKey(name)) {
            this.glideBuffer.put(name, 0);
        }
        if (!this.lastYDelta.containsKey(name)) {
            this.lastYDelta.put(name, 0.0);
        }
        if (!this.lastYcoord.containsKey(name)) {
            this.lastYcoord.put(name, player.getLocation().getY());
        }
        if ((math = (currentY = player.getLocation().getY()) - this.lastYcoord.get(name)) < 0.0 && math > -3.4 && !AntiCheat.getManager().getBackend().isMovingExempt(player)) {
            if (math <= this.lastYDelta.get(name) && player.getEyeLocation().getBlock().getType() != Material.LADDER && !Utilities.isInWater(player) && !Utilities.isInWeb(player) && Utilities.cantStandAtSingle(player.getLocation().getBlock())) {
                if (math <= 0.3) {
                    int currentBuffer = this.glideBuffer.get(name);
                    this.glideBuffer.put(name, currentBuffer + 1);
                    if (currentBuffer + 1 >= this.magic.FLIGHT_LIMIT()) {
                        if (!this.silentMode()) {
                            this.sendFormattedMessage(player, "Fly hacking on the y-axis detected.");
                        }
                        this.lastYDelta.put(name, math);
                        return new CheckResult(CheckResult.Result.FAILED, name + " attempted to fall too slowly!");
                    }
                }
            } else {
                int currentBuffer = this.glideBuffer.get(name) - 1;
                this.glideBuffer.put(name, currentBuffer > 0 ? currentBuffer : 0);
            }
        }
        this.lastYDelta.put(name, math);
        return PASS;
    }

    public CheckResult checkFlight(Player player, Distance distance) {
        if (distance.getYDifference() > (double)this.magic.TELEPORT_MIN()) {
            return PASS;
        }
        String name = player.getName();
        double y1 = distance.fromY();
        double y2 = distance.toY();
        if (!AntiCheat.getManager().getBackend().isMovingExempt(player) && !Utilities.isHoveringOverWater(player.getLocation(), 1) && Utilities.cantStandAtExp(player.getLocation()) && Utilities.blockIsnt(player.getLocation().getBlock().getRelative(BlockFace.DOWN), new Material[]{Material.FENCE, Material.FENCE_GATE, Material.COBBLE_WALL})) {
            if (!this.blocksOverFlight.containsKey(name)) {
                this.blocksOverFlight.put(name, 0.0);
            }
            this.blocksOverFlight.put(name, this.blocksOverFlight.get(name) + distance.getXDifference() + distance.getYDifference() + distance.getZDifference());
            if (y1 > y2) {
                this.blocksOverFlight.put(name, this.blocksOverFlight.get(name) - distance.getYDifference());
            }
            if (this.blocksOverFlight.get(name) > this.magic.FLIGHT_BLOCK_LIMIT() && y1 <= y2) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " flew over " + this.blocksOverFlight.get(name) + " blocks (max=" + this.magic.FLIGHT_BLOCK_LIMIT() + ")");
            }
        } else {
            this.blocksOverFlight.put(name, 0.0);
        }
        return PASS;
    }

    public void logAscension(Player player, double y1, double y2) {
        String name = player.getName();
        if (y1 < y2 && !this.isAscending.contains(name)) {
            this.isAscending.add(name);
        } else {
            this.isAscending.remove(name);
        }
    }

    public CheckResult checkAscension(Player player, double y1, double y2) {
        int max = this.magic.ASCENSION_COUNT_MAX();
        String string = "";
        if (player.hasPotionEffect(PotionEffectType.JUMP)) {
            max += 12;
            string = " with jump potion";
        }
        Block block = player.getLocation().getBlock();
        if (!(AntiCheat.getManager().getBackend().isMovingExempt(player) || Utilities.isInWater(player) || AntiCheat.getManager().getBackend().getBlockCheck().justBroke(player) || Utilities.isClimbableBlock(player.getLocation().getBlock()) || player.isInsideVehicle())) {
            String name = player.getName();
            if (y1 < y2) {
                if (!(block.getRelative(BlockFace.NORTH).isLiquid() || block.getRelative(BlockFace.SOUTH).isLiquid() || block.getRelative(BlockFace.EAST).isLiquid() || block.getRelative(BlockFace.WEST).isLiquid())) {
                    this.increment(player, this.ascensionCount, max);
                    if (this.ascensionCount.get(name) >= max) {
                        return new CheckResult(CheckResult.Result.FAILED, player.getName() + " ascended " + this.ascensionCount.get(name) + " times in a row (max = " + max + string + ")");
                    }
                }
            } else {
                this.ascensionCount.put(name, 0);
            }
        }
        return PASS;
    }
}

