/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.check.checks;

import java.util.HashMap;
import java.util.Map;
import net.dynamicdev.anticheat.check.AntiCheatCheck;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class InventoryCheck
extends AntiCheatCheck {
    private Map<String, Integer> blocksDropped = new HashMap<String, Integer>();
    private Map<String, Long> lastInventoryTime = new HashMap<String, Long>();
    private Map<String, Long> inventoryTime = new HashMap<String, Long>();
    private Map<String, Integer> inventoryClicks = new HashMap<String, Integer>();
    private Map<String, Long> blockTime = new HashMap<String, Long>();

    public InventoryCheck(AntiCheatManager instance) {
        super(instance);
    }

    public CheckResult checkFastDrop(Player player) {
        this.increment(player, this.blocksDropped, 10);
        if (!this.blockTime.containsKey(player.getName())) {
            this.blockTime.put(player.getName(), System.currentTimeMillis());
            return new CheckResult(CheckResult.Result.PASSED);
        }
        if (this.blocksDropped.get(player.getName()).intValue() == this.magic.DROP_CHECK()) {
            long time = System.currentTimeMillis() - this.blockTime.get(player.getName());
            this.blockTime.remove(player.getName());
            this.blocksDropped.remove(player.getName());
            if (time < (long)this.magic.DROP_TIME_MIN()) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " dropped an item too fast (actual time=" + time + ", min time=" + this.magic.DROP_TIME_MIN() + ")");
            }
        }
        return PASS;
    }

    public CheckResult checkInventoryClicks(Player player) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return PASS;
        }
        String name = player.getName();
        int clicks = 1;
        if (this.inventoryClicks.containsKey(name)) {
            clicks = this.inventoryClicks.get(name) + 1;
        }
        this.inventoryClicks.put(name, clicks);
        if (clicks == 1) {
            this.inventoryTime.put(name, System.currentTimeMillis());
        } else if (clicks == this.magic.INVENTORY_CHECK()) {
            long time = System.currentTimeMillis() - this.inventoryTime.get(name);
            this.inventoryClicks.put(name, 0);
            if (time < (long)this.magic.INVENTORY_TIMEMIN()) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " clicked inventory slots " + clicks + " times in " + time + " ms (max=" + this.magic.INVENTORY_CHECK() + " in " + this.magic.INVENTORY_TIMEMIN() + " ms)");
            }
        }
        return PASS;
    }
}

