/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.check.checks;

import java.util.HashMap;
import java.util.Map;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.AntiCheatCheck;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class EntityCheck
extends AntiCheatCheck {
    private Map<String, Integer> projectilesShot = new HashMap<String, Integer>();
    private Map<String, Long> startEat = new HashMap<String, Long>();
    private Map<String, Long> lastHeal = new HashMap<String, Long>();
    private Map<String, Long> projectileTime = new HashMap<String, Long>();
    private Map<String, Long> bowWindUp = new HashMap<String, Long>();
    private Map<String, Long> sprinted = new HashMap<String, Long>();
    private Map<String, Long> lastAttack = new HashMap<String, Long>();

    public EntityCheck(AntiCheatManager instance) {
        super(instance);
    }

    public void logSprint(Player player) {
        this.sprinted.put(player.getName(), System.currentTimeMillis());
    }

    public CheckResult checkFastBow(Player player, float force) {
        int ticks = (int)((System.currentTimeMillis() - this.bowWindUp.get(player.getName())) * 20L / 1000L + 3L);
        this.bowWindUp.remove(player.getName());
        float f = (float)ticks / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        float f2 = f = f > 1.0f ? 1.0f : f;
        if ((double)Math.abs(force - f) > this.magic.BOW_ERROR()) {
            return new CheckResult(CheckResult.Result.FAILED, player.getName() + " fired their bow too fast (actual force=" + force + ", calculated force=" + f + ")");
        }
        return PASS;
    }

    public CheckResult checkProjectile(Player player) {
        this.increment(player, this.projectilesShot, 10);
        if (!this.projectileTime.containsKey(player.getName())) {
            this.projectileTime.put(player.getName(), System.currentTimeMillis());
            return new CheckResult(CheckResult.Result.PASSED);
        }
        if (this.projectilesShot.get(player.getName()).intValue() == this.magic.PROJECTILE_CHECK()) {
            long time = System.currentTimeMillis() - this.projectileTime.get(player.getName());
            this.projectileTime.remove(player.getName());
            this.projectilesShot.remove(player.getName());
            if (time < (long)this.magic.PROJECTILE_TIME_MIN()) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " wound up a bow too fast (actual time=" + time + ", min time=" + this.magic.PROJECTILE_TIME_MIN() + ")");
            }
        }
        return PASS;
    }

    public CheckResult checkLongReachDamage(Player player, double x, double y, double z) {
        double i;
        String string = player.getName() + " reached too far for an entity";
        double d = x >= this.magic.ENTITY_MAX_DISTANCE() ? x : (y > this.magic.ENTITY_MAX_DISTANCE() ? y : (i = z > this.magic.ENTITY_MAX_DISTANCE() ? z : -1.0));
        if (i != -1.0) {
            return new CheckResult(CheckResult.Result.FAILED, string + " (distance=" + i + ", max=" + this.magic.ENTITY_MAX_DISTANCE() + ")");
        }
        return PASS;
    }

    public CheckResult checkSight(Player player, Entity entity) {
        return PASS;
    }

    public void logBowWindUp(Player player) {
        this.bowWindUp.put(player.getName(), System.currentTimeMillis());
    }

    public void logEatingStart(Player player) {
        this.startEat.put(player.getName(), System.currentTimeMillis());
    }

    public void logHeal(Player player) {
        this.lastHeal.put(player.getName(), System.currentTimeMillis());
    }

    public CheckResult checkSprintDamage(Player player) {
        if (this.isDoing(player, this.sprinted, this.magic.SPRINT_MIN())) {
            return new CheckResult(CheckResult.Result.FAILED, player.getName() + " sprinted and damaged an entity too fast (min sprint=" + this.magic.SPRINT_MIN() + " ms)");
        }
        return PASS;
    }

    public CheckResult checkFightSpeed(Player player) {
        long math;
        String name = player.getName();
        if (!this.lastAttack.containsKey(name)) {
            this.lastAttack.put(name, System.currentTimeMillis());
        }
        if ((math = System.currentTimeMillis() - this.lastAttack.get(name)) < (long)this.magic.FIGHT_TIME_MIN()) {
            return new CheckResult(CheckResult.Result.FAILED, name + " attempted to attack faster than normal. (min=" + this.magic.FIGHT_TIME_MIN() + " | them=" + math);
        }
        return PASS;
    }

    public CheckResult checkFightDistance(Player player, LivingEntity damaged) {
        Location playerLoc;
        String name = player.getName();
        Location entityLoc = damaged.getLocation().add(0.0, damaged.getEyeHeight(), 0.0);
        double distance = Utilities.getDistance3D(entityLoc, playerLoc = player.getLocation().add(0.0, player.getEyeHeight(), 0.0));
        if (distance > this.magic.FIGHT_MIN_DISTANCE()) {
            return new CheckResult(CheckResult.Result.FAILED, name + " attempted to attack something too far away. (min=" + this.magic.FIGHT_MIN_DISTANCE() + " | them=" + distance);
        }
        return PASS;
    }

    public CheckResult checkFightRotation(Player player, LivingEntity damaged) {
        double offset = 0.0;
        Location entityLoc = damaged.getLocation().add(0.0, damaged.getEyeHeight(), 0.0);
        Location playerLoc = player.getLocation().add(0.0, player.getEyeHeight(), 0.0);
        Vector playerRotation = new Vector(playerLoc.getYaw(), playerLoc.getPitch(), 0.0f);
        Vector expectedRotation = Utilities.getRotation(playerLoc, entityLoc);
        double deltaYaw = Utilities.clamp180(playerRotation.getX() - expectedRotation.getX());
        double deltaPitch = Utilities.clamp180(playerRotation.getY() - expectedRotation.getY());
        double horizontalDistance = Utilities.getHorizontalDistance(playerLoc, entityLoc);
        double distance = Utilities.getDistance3D(playerLoc, entityLoc);
        double offsetX = deltaYaw * horizontalDistance * distance;
        double offsetY = deltaPitch * Math.abs(entityLoc.getY() - playerLoc.getY()) * distance;
        offset += Math.abs(offsetX);
        if ((offset += Math.abs(offsetY)) > (double)this.magic.DIRECTION_MAX_BUFFER()) {
            return new CheckResult(CheckResult.Result.FAILED, player.getName() + " attempted to attack something without looking at it.");
        }
        return PASS;
    }

    public CheckResult checkAnimation(Player player, Entity e) {
        if (!AntiCheat.getManager().getBackend().justAnimated(player)) {
            return new CheckResult(CheckResult.Result.FAILED, player.getName() + " didn't animate before damaging a " + e.getType());
        }
        return PASS;
    }

    public CheckResult checkFastHeal(Player player) {
        if (this.lastHeal.containsKey(player.getName())) {
            long l = this.lastHeal.get(player.getName());
            this.lastHeal.remove(player.getName());
            if (System.currentTimeMillis() - l < (long)this.magic.HEAL_TIME_MIN()) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " healed too quickly (time=" + (System.currentTimeMillis() - l) + " ms, min=" + this.magic.HEAL_TIME_MIN() + " ms)");
            }
        }
        return PASS;
    }

    public CheckResult checkFastEat(Player player) {
        if (this.startEat.containsKey(player.getName())) {
            long l = this.startEat.get(player.getName());
            this.startEat.remove(player.getName());
            if (System.currentTimeMillis() - l < (long)this.magic.EAT_TIME_MIN()) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " ate too quickly (time=" + (System.currentTimeMillis() - l) + " ms, min=" + this.magic.EAT_TIME_MIN() + " ms)");
            }
        }
        return PASS;
    }
}

