/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.check.checks;

import java.util.HashMap;
import java.util.Map;
import net.dynamicdev.anticheat.check.AntiCheatCheck;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import net.dynamicdev.anticheat.util.User;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.entity.Player;

public class ChatCheck
extends AntiCheatCheck {
    private Map<String, Integer> chatLevel = new HashMap<String, Integer>();
    private Map<String, Integer> commandLevel = new HashMap<String, Integer>();

    public ChatCheck(AntiCheatManager instance) {
        super(instance);
    }

    public void resetChatLevel(User user) {
        this.chatLevel.put(user.getName(), 0);
    }

    public void processChatSpammer(Player player) {
        int level;
        User user = this.manager.getUserManager().getUser(player.getName());
        int n = level = this.chatLevel.containsKey(user.getName()) ? this.chatLevel.get(user.getName()) : 0;
        if (player != null && player.isOnline() && level >= this.magic.CHAT_ACTION_ONE_LEVEL()) {
            String event = level >= this.magic.CHAT_ACTION_TWO_LEVEL() ? this.manager.getConfiguration().getConfig().chatSpamActionTwo.getValue() : this.manager.getConfiguration().getConfig().chatSpamActionOne.getValue();
            this.manager.getUserManager().execute(this.manager.getUserManager().getUser(player.getName()), Utilities.stringToList(event), CheckType.CHAT_SPAM, this.lang.SPAM_KICK_REASON(), Utilities.stringToList(this.lang.SPAM_WARNING()), this.lang.SPAM_BAN_REASON());
        }
        this.chatLevel.put(user.getName(), level + 1);
    }

    public void processCommandSpammer(Player player) {
        int level;
        User user = this.manager.getUserManager().getUser(player.getName());
        int n = level = this.commandLevel.containsKey(user.getName()) ? this.commandLevel.get(user.getName()) : 0;
        if (player != null && player.isOnline() && level >= this.magic.COMMAND_ACTION_ONE_LEVEL()) {
            String event = level >= this.magic.COMMAND_ACTION_TWO_LEVEL() ? this.manager.getConfiguration().getConfig().commandSpamActionTwo.getValue() : this.manager.getConfiguration().getConfig().commandSpamActionOne.getValue();
            this.manager.getUserManager().execute(this.manager.getUserManager().getUser(player.getName()), Utilities.stringToList(event), CheckType.COMMAND_SPAM, this.lang.SPAM_KICK_REASON(), Utilities.stringToList(this.lang.SPAM_WARNING()), this.lang.SPAM_BAN_REASON());
        }
        this.commandLevel.put(user.getName(), level + 1);
    }

    public CheckResult checkChatSpam(Player player, String msg) {
        String name = player.getName();
        User user = this.manager.getUserManager().getUser(name);
        if (user.getLastMessageTime() != -1L) {
            String m;
            for (int i = 0; i < 2 && (m = user.getMessage(i)) != null; ++i) {
                Long l = user.getMessageTime(i);
                if (System.currentTimeMillis() - l > (long)(this.magic.CHAT_REPEAT_MIN() * 100)) {
                    user.clearMessages();
                    break;
                }
                if (this.manager.getConfiguration().getConfig().blockChatSpamRepetition.getValue().booleanValue() && m.equalsIgnoreCase(msg) && i == 1) {
                    this.manager.getLoggingManager().logFineInfo(player.getName() + " spam-repeated \"" + msg + "\"");
                    return new CheckResult(CheckResult.Result.FAILED, this.lang.SPAM_WARNING());
                }
                if (!this.manager.getConfiguration().getConfig().blockChatSpamSpeed.getValue().booleanValue() || System.currentTimeMillis() - user.getLastCommandTime() >= (long)(this.magic.COMMAND_MIN() * 2)) continue;
                this.manager.getLoggingManager().logFineInfo(player.getName() + " spammed quickly \"" + msg + "\"");
                return new CheckResult(CheckResult.Result.FAILED, this.lang.SPAM_WARNING());
            }
        }
        user.addMessage(msg);
        return PASS;
    }

    public CheckResult checkCommandSpam(Player player, String cmd) {
        String name = player.getName();
        User user = this.manager.getUserManager().getUser(name);
        if (user.getLastCommandTime() != -1L) {
            String m;
            for (int i = 0; i < 2 && (m = user.getCommand(i)) != null; ++i) {
                Long l = user.getCommandTime(i);
                if (System.currentTimeMillis() - l > (long)(this.magic.COMMAND_REPEAT_MIN() * 100)) {
                    user.clearCommands();
                    break;
                }
                if (this.manager.getConfiguration().getConfig().blockCommandSpamRepetition.getValue().booleanValue() && m.equalsIgnoreCase(cmd) && i == 1) {
                    return new CheckResult(CheckResult.Result.FAILED, this.lang.SPAM_WARNING());
                }
                if (!this.manager.getConfiguration().getConfig().blockCommandSpamSpeed.getValue().booleanValue() || System.currentTimeMillis() - user.getLastCommandTime() >= (long)(this.magic.COMMAND_MIN() * 2)) continue;
                return new CheckResult(CheckResult.Result.FAILED, this.lang.SPAM_WARNING());
            }
        }
        user.addCommand(cmd);
        return PASS;
    }
}

