/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.check.checks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.AntiCheatCheck;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import net.dynamicdev.anticheat.util.Utilities;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.util.Vector;

public class BlockCheck
extends AntiCheatCheck {
    private Map<String, Integer> fastBreakViolation = new HashMap<String, Integer>();
    private Map<String, Integer> fastBreaks = new HashMap<String, Integer>();
    private Map<String, Boolean> blockBreakHolder = new HashMap<String, Boolean>();
    private Map<String, Long> lastBlockBroken = new HashMap<String, Long>();
    private Map<String, Integer> fastPlaceViolation = new HashMap<String, Integer>();
    private Map<String, Long> lastBlockPlaced = new HashMap<String, Long>();
    private Map<String, Long> lastBlockPlaceTime = new HashMap<String, Long>();
    private Map<String, Long> instantBreakExempt = new HashMap<String, Long>();
    private Map<String, Material> itemInHand = new HashMap<String, Material>();
    private HashSet<Byte> transparent = new HashSet();
    private Map<String, Long> brokenBlock = new HashMap<String, Long>();
    private Map<String, Long> placedBlock = new HashMap<String, Long>();

    public BlockCheck(AntiCheatManager instance) {
        super(instance);
        this.transparent.add((byte)-1);
    }

    public boolean justPlaced(Player player) {
        return this.isDoing(player, this.placedBlock, this.magic.BLOCK_PLACE_MIN());
    }

    public void logBlockPlace(Player player) {
        this.placedBlock.put(player.getName(), System.currentTimeMillis());
    }

    public void logInstantBreak(Player player) {
        this.instantBreakExempt.put(player.getName(), System.currentTimeMillis());
    }

    public boolean isInstantBreakExempt(Player player) {
        return this.isDoing(player, this.instantBreakExempt, this.magic.INSTANT_BREAK_TIME());
    }

    public void logBlockBreak(Player player) {
        this.brokenBlock.put(player.getName(), System.currentTimeMillis());
        AntiCheat.getManager().getBackend().resetAnimation(player);
    }

    public boolean justBroke(Player player) {
        return this.isDoing(player, this.brokenBlock, this.magic.BLOCK_BREAK_MIN());
    }

    public void logAnimation(Player player) {
        AntiCheat.getManager().getBackend().animated.put(player.getName(), System.currentTimeMillis());
        this.increment(player, AntiCheat.getManager().getBackend().blockPunches, this.magic.BLOCK_PUNCH_MIN());
        this.itemInHand.put(player.getName(), player.getItemInHand().getType());
        AntiCheat.getManager().getBackend().interactionCount.put(player.getName(), 0);
    }

    public CheckResult checkLongReachBlock(Player player, double x, double y, double z) {
        double i;
        double distance;
        if (this.isInstantBreakExempt(player)) {
            return new CheckResult(CheckResult.Result.PASSED);
        }
        String string = player.getName() + " reached too far for a block";
        double d = player.getGameMode() == GameMode.CREATIVE ? this.magic.BLOCK_MAX_DISTANCE_CREATIVE() : (distance = player.getLocation().getDirection().getY() > 0.9 ? this.magic.BLOCK_MAX_DISTANCE_CREATIVE() : this.magic.BLOCK_MAX_DISTANCE());
        double d2 = x >= distance ? x : (y > distance ? y : (i = z > distance ? z : -1.0));
        if (i != -1.0) {
            return new CheckResult(CheckResult.Result.FAILED, string + " (distance=" + i + ", max=" + this.magic.BLOCK_MAX_DISTANCE() + ")");
        }
        return PASS;
    }

    public CheckResult checkSwing(Player player, Block block) {
        String name = player.getName();
        if (!(this.isInstantBreakExempt(player) || player.getInventory().getItemInHand().containsEnchantment(Enchantment.DIG_SPEED) || player.getInventory().getItemInHand().getType() == Material.SHEARS && block.getType() == Material.LEAVES || AntiCheat.getManager().getBackend().blockPunches.get(name) == null || player.getGameMode() == GameMode.CREATIVE)) {
            int i = AntiCheat.getManager().getBackend().blockPunches.get(name);
            if (i < this.magic.BLOCK_PUNCH_MIN()) {
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to break a block of " + block.getType() + " after only " + i + " punches (min=" + this.magic.BLOCK_PUNCH_MIN() + ")");
            }
            AntiCheat.getManager().getBackend().blockPunches.put(name, 0);
        }
        return PASS;
    }

    public CheckResult checkFastBreak(Player player, Block block) {
        int i;
        Long math;
        String name;
        long timemax;
        int violations = this.magic.FASTBREAK_MAXVIOLATIONS();
        long l = timemax = this.isInstantBreakExempt(player) ? 0L : Utilities.calcSurvivalFastBreak(player.getInventory().getItemInHand(), block.getType());
        if (player.getGameMode() == GameMode.CREATIVE) {
            violations = this.magic.FASTBREAK_MAXVIOLATIONS_CREATIVE();
            timemax = this.magic.FASTBREAK_TIMEMAX_CREATIVE();
        }
        if (!this.fastBreakViolation.containsKey(name = player.getName())) {
            this.fastBreakViolation.put(name, 0);
        } else {
            math = System.currentTimeMillis() - this.lastBlockBroken.get(name);
            i = this.fastBreakViolation.get(name);
            if (i > violations && math < (long)this.magic.FASTBREAK_MAXVIOLATIONTIME()) {
                this.lastBlockBroken.put(name, System.currentTimeMillis());
                if (!this.silentMode()) {
                    this.sendFormattedMessage(player, "Fastbreaking detected. Please wait 10 seconds before breaking blocks.");
                }
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " broke blocks too fast " + i + " times in a row (max=" + violations + ")");
            }
            if (this.fastBreakViolation.get(name) > 0 && math > (long)this.magic.FASTBREAK_MAXVIOLATIONTIME()) {
                this.fastBreakViolation.put(name, 0);
            }
        }
        if (!this.fastBreaks.containsKey(name) || !this.lastBlockBroken.containsKey(name)) {
            if (!this.lastBlockBroken.containsKey(name)) {
                this.lastBlockBroken.put(name, System.currentTimeMillis());
            }
            if (!this.fastBreaks.containsKey(name)) {
                this.fastBreaks.put(name, 0);
            }
        } else {
            math = System.currentTimeMillis() - this.lastBlockBroken.get(name);
            if (math != 0L && timemax != 0L) {
                if (math < timemax) {
                    if (this.fastBreakViolation.containsKey(name) && this.fastBreakViolation.get(name) > 0) {
                        this.fastBreakViolation.put(name, this.fastBreakViolation.get(name) + 1);
                    } else {
                        this.fastBreaks.put(name, this.fastBreaks.get(name) + 1);
                    }
                    this.blockBreakHolder.put(name, false);
                }
                if (this.fastBreaks.get(name) >= this.magic.FASTBREAK_LIMIT() && math < timemax) {
                    i = this.fastBreaks.get(name);
                    this.fastBreaks.put(name, 0);
                    this.fastBreakViolation.put(name, this.fastBreakViolation.get(name) + 1);
                    return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to break " + i + " blocks in " + math + " ms (max=" + this.magic.FASTBREAK_LIMIT() + " in " + timemax + " ms)");
                }
                if (this.fastBreaks.get(name) >= this.magic.FASTBREAK_LIMIT() || this.fastBreakViolation.get(name) > 0) {
                    if (!this.blockBreakHolder.containsKey(name) || !this.blockBreakHolder.get(name).booleanValue()) {
                        this.blockBreakHolder.put(name, true);
                    } else {
                        this.fastBreaks.put(name, this.fastBreaks.get(name) - 1);
                        if (this.fastBreakViolation.get(name) > 0) {
                            this.fastBreakViolation.put(name, this.fastBreakViolation.get(name) - 1);
                        }
                        this.blockBreakHolder.put(name, false);
                    }
                }
            }
        }
        this.lastBlockBroken.put(name, System.currentTimeMillis());
        return PASS;
    }

    public CheckResult checkFastPlace(Player player) {
        int violations = player.getGameMode() == GameMode.CREATIVE ? this.magic.FASTPLACE_MAXVIOLATIONS_CREATIVE() : this.magic.FASTPLACE_MAXVIOLATIONS();
        long time = System.currentTimeMillis();
        String name = player.getName();
        if (!this.lastBlockPlaceTime.containsKey(name) || !this.fastPlaceViolation.containsKey(name)) {
            this.lastBlockPlaceTime.put(name, 0L);
            if (!this.fastPlaceViolation.containsKey(name)) {
                this.fastPlaceViolation.put(name, 0);
            }
        } else if (this.fastPlaceViolation.containsKey(name) && this.fastPlaceViolation.get(name) > violations) {
            AntiCheat.debugLog("Noted that fastPlaceViolation contains key " + name + " with value " + this.fastPlaceViolation.get(name));
            Long math = System.currentTimeMillis() - this.lastBlockPlaced.get(name);
            AntiCheat.debugLog("Player lastBlockPlaced value = " + this.lastBlockPlaced + ", diff=" + math);
            double multiplier = 0.75;
            if (this.lastBlockPlaced.get(name) > 0L && (double)math.longValue() < (double)this.magic.FASTPLACE_MAXVIOLATIONTIME() * multiplier) {
                this.lastBlockPlaced.put(name, time);
                if (!this.silentMode()) {
                    this.sendFormattedMessage(player, "Fastplacing detected. Please wait 10 seconds before placing blocks.");
                }
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " placed blocks too fast " + this.fastBreakViolation.get(name) + " times in a row (max=" + violations + ")");
            }
            if (this.lastBlockPlaced.get(name) > 0L && math > (long)this.magic.FASTPLACE_MAXVIOLATIONTIME()) {
                AntiCheat.debugLog("Reset facePlaceViolation for " + name);
                this.fastPlaceViolation.put(name, 0);
            }
        } else if (this.lastBlockPlaced.containsKey(name)) {
            long last = this.lastBlockPlaced.get(name);
            long lastTime = this.lastBlockPlaceTime.get(name);
            long thisTime = time - last;
            if (lastTime != 0L && thisTime < (long)this.magic.FASTPLACE_TIMEMIN()) {
                this.lastBlockPlaceTime.put(name, time - last);
                this.lastBlockPlaced.put(name, time);
                this.fastPlaceViolation.put(name, this.fastPlaceViolation.get(name) + 1);
                return new CheckResult(CheckResult.Result.FAILED, player.getName() + " tried to place a block " + thisTime + " ms after the last one (min=" + this.magic.FASTPLACE_TIMEMIN() + " ms)");
            }
            this.lastBlockPlaceTime.put(name, time - last);
        }
        this.lastBlockPlaced.put(name, time);
        return PASS;
    }

    public CheckResult checkAutoTool(Player player) {
        if (this.itemInHand.containsKey(player.getName()) && this.itemInHand.get(player.getName()) != player.getItemInHand().getType()) {
            return new CheckResult(CheckResult.Result.FAILED, player.getName() + " switched tools too fast (had " + this.itemInHand.get(player.getName()) + ", has " + player.getItemInHand().getType() + ")");
        }
        return PASS;
    }

    public CheckResult checkBlockRotation(Player player, BlockBreakEvent event) {
        double offset = 0.0;
        Location blockLoc = event.getBlock().getLocation().add(0.5, 0.6, 0.5);
        Location playerLoc = player.getLocation().add(0.0, player.getEyeHeight(), 0.0);
        Vector playerRotation = new Vector(playerLoc.getYaw(), playerLoc.getPitch(), 0.0f);
        Vector expectedRotation = Utilities.getRotation(playerLoc, blockLoc);
        double deltaYaw = Utilities.clamp180(playerRotation.getX() - expectedRotation.getX());
        double deltaPitch = Utilities.clamp180(playerRotation.getY() - expectedRotation.getY());
        double horizontalDistance = Utilities.getHorizontalDistance(playerLoc, blockLoc);
        double distance = Utilities.getDistance3D(playerLoc, blockLoc);
        double offsetX = deltaYaw * horizontalDistance * distance;
        double offsetY = deltaPitch * Math.abs(blockLoc.getY() - playerLoc.getY()) * distance;
        offset += Math.abs(offsetX);
        if ((offset += Math.abs(offsetY)) > (double)this.magic.DIRECTION_MAX_BUFFER()) {
            // empty if block
        }
        return PASS;
    }
}

