/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.check;

import java.util.HashMap;
import java.util.Map;
import net.dynamicdev.anticheat.check.checks.BlockCheck;
import net.dynamicdev.anticheat.check.checks.ChatCheck;
import net.dynamicdev.anticheat.check.checks.EntityCheck;
import net.dynamicdev.anticheat.check.checks.InventoryCheck;
import net.dynamicdev.anticheat.check.checks.MovementCheck;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.config.providers.Magic;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class Backend {
    public Map<String, Long> animated = new HashMap<String, Long>();
    public Map<String, Integer> interactionCount = new HashMap<String, Integer>();
    public Map<String, Integer> blockPunches = new HashMap<String, Integer>();
    private MovementCheck movementCheck;
    private BlockCheck blockCheck;
    private ChatCheck chatCheck;
    private EntityCheck entityCheck;
    private InventoryCheck inventoryCheck;
    private Magic magic;

    public Backend(AntiCheatManager instance) {
        this.magic = instance.getConfiguration().getMagic();
        this.movementCheck = new MovementCheck(instance);
        this.blockCheck = new BlockCheck(instance);
        this.chatCheck = new ChatCheck(instance);
        this.entityCheck = new EntityCheck(instance);
        this.inventoryCheck = new InventoryCheck(instance);
    }

    public MovementCheck getMovementCheck() {
        return this.movementCheck;
    }

    public BlockCheck getBlockCheck() {
        return this.blockCheck;
    }

    public EntityCheck getEntityCheck() {
        return this.entityCheck;
    }

    public ChatCheck getChatCheck() {
        return this.chatCheck;
    }

    public InventoryCheck getInventoryCheck() {
        return this.inventoryCheck;
    }

    public void updateConfig(Configuration config) {
        this.movementCheck.setConfig(config);
        this.blockCheck.setConfig(config);
        this.chatCheck.setConfig(config);
        this.entityCheck.setConfig(config);
        this.inventoryCheck.setConfig(config);
    }

    protected boolean isDoing(Player player, Map<String, Long> map, double max) {
        if (map.containsKey(player.getName())) {
            if (max != -1.0) {
                if ((double)((System.currentTimeMillis() - map.get(player.getName())) / 1000L) > max) {
                    map.remove(player.getName());
                    return false;
                }
                return true;
            }
            if (map.get(player.getName()) < System.currentTimeMillis()) {
                map.remove(player.getName());
                return false;
            }
            return true;
        }
        return false;
    }

    public void resetAnimation(Player player) {
        this.animated.remove(player.getName());
        this.blockPunches.put(player.getName(), 0);
    }

    public boolean justAnimated(Player player) {
        String name = player.getName();
        if (this.animated.containsKey(name)) {
            long time = System.currentTimeMillis() - this.animated.get(name);
            int count = this.interactionCount.get(player.getName()) + 1;
            this.interactionCount.put(player.getName(), count);
            if (count > this.magic.ANIMATION_INTERACT_MAX()) {
                this.animated.remove(player.getName());
                return false;
            }
            return time < (long)this.magic.ANIMATION_MIN();
        }
        return false;
    }

    public void logDamage(Player player, int type) {
        long time;
        switch (type) {
            case 1: {
                time = this.magic.DAMAGE_TIME();
                break;
            }
            case 2: {
                time = this.magic.KNOCKBACK_DAMAGE_TIME();
                break;
            }
            case 3: {
                time = this.magic.EXPLOSION_DAMAGE_TIME();
                break;
            }
            default: {
                time = this.magic.DAMAGE_TIME();
            }
        }
        this.movementCheck.getMovingExempt().put(player.getName(), System.currentTimeMillis() + time);
    }

    public void logEnterExit(Player player) {
        this.movementCheck.getMovingExempt().put(player.getName(), System.currentTimeMillis() + (long)this.magic.ENTERED_EXITED_TIME());
    }

    public void logToggleSneak(Player player) {
        this.movementCheck.getSneakExempt().put(player.getName(), System.currentTimeMillis() + (long)this.magic.SNEAK_TIME());
    }

    public void logTeleport(Player player) {
        this.movementCheck.getMovingExempt().put(player.getName(), System.currentTimeMillis() + (long)this.magic.TELEPORT_TIME());
        this.movementCheck.logTeleport(player);
    }

    public void logExitFly(Player player) {
        this.movementCheck.getMovingExempt().put(player.getName(), System.currentTimeMillis() + (long)this.magic.EXIT_FLY_TIME());
    }

    public void logJoin(Player player) {
        this.movementCheck.getMovingExempt().put(player.getName(), System.currentTimeMillis() + (long)this.magic.JOIN_TIME());
        if (player.getLocation().getBlock().getType() == Material.AIR) {
            Location setLocation = player.getLocation();
            int x = player.getLocation().getBlockX();
            int z = player.getLocation().getBlockZ();
            for (int y = player.getLocation().getBlockY(); y > 0; --y) {
                if (!player.getWorld().getBlockAt(x, y, z).getType().isSolid()) continue;
                setLocation = new Location(player.getWorld(), (double)x, (double)(y + 1), (double)z);
                break;
            }
            player.teleport(setLocation);
        } else if (player.getEyeLocation().getBlock().getType().isSolid()) {
            player.teleport(player.getWorld().getHighestBlockAt(player.getLocation()).getLocation());
        }
    }

    public boolean isMovingExempt(Player player) {
        return this.isDoing(player, this.movementCheck.getMovingExempt(), -1.0);
    }

    public boolean isSneakExempt(Player player) {
        return this.isDoing(player, this.movementCheck.getSneakExempt(), -1.0);
    }

    public boolean isSpeedExempt(Player player) {
        return this.isMovingExempt(player) || this.movementCheck.justVelocity(player);
    }
}

