/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.check;

import java.util.Map;
import net.dynamicdev.anticheat.check.CheckResult;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.config.providers.Lang;
import net.dynamicdev.anticheat.config.providers.Magic;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class AntiCheatCheck {
    protected Magic magic;
    protected AntiCheatManager manager = null;
    protected Lang lang = null;
    protected static final CheckResult PASS = new CheckResult(CheckResult.Result.PASSED);
    protected static final String DEPTH_STRIDER_ENCHANT = "DEPTH_STRIDER";

    public AntiCheatCheck(AntiCheatManager instance) {
        this.magic = instance.getConfiguration().getMagic();
        this.manager = instance;
        this.lang = this.manager.getConfiguration().getLang();
    }

    public void updateConfig(Configuration config) {
        this.magic = config.getMagic();
        this.lang = config.getLang();
    }

    public void setConfig(Configuration config) {
        this.magic = config.getMagic();
        this.lang = config.getLang();
    }

    protected boolean isDoing(Player player, Map<String, Long> map, double max) {
        if (map.containsKey(player.getName())) {
            if (max != -1.0) {
                if ((double)((System.currentTimeMillis() - map.get(player.getName())) / 1000L) > max) {
                    map.remove(player.getName());
                    return false;
                }
                return true;
            }
            if (map.get(player.getName()) < System.currentTimeMillis()) {
                map.remove(player.getName());
                return false;
            }
            return true;
        }
        return false;
    }

    public int increment(Player player, Map<String, Integer> map, int num) {
        String name = player.getName();
        if (map.get(name) == null) {
            map.put(name, 1);
            return 1;
        }
        int amount = map.get(name) + 1;
        if (amount < num + 1) {
            map.put(name, amount);
            return amount;
        }
        map.put(name, num);
        return num;
    }

    public boolean silentMode() {
        return this.manager.getConfiguration().getConfig().silentMode.getValue();
    }

    public void sendFormattedMessage(Player player, String message) {
        player.sendMessage(ChatColor.RED + "[AntiCheat+] " + message);
    }
}

