/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat.api;

import java.util.List;
import net.dynamicdev.anticheat.AntiCheat;
import net.dynamicdev.anticheat.check.CheckType;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import net.dynamicdev.anticheat.manage.CheckManager;
import net.dynamicdev.anticheat.manage.UserManager;
import net.dynamicdev.anticheat.util.Group;
import net.dynamicdev.anticheat.xray.XRayTracker;
import org.bukkit.entity.Player;
import sun.reflect.Reflection;

public class AntiCheatAPI {
    private static CheckManager chk = AntiCheat.getManager().getCheckManager();
    private static UserManager umr = AntiCheat.getManager().getUserManager();
    private static XRayTracker xtracker = AntiCheat.getManager().getXRayTracker();

    public static void activateCheck(CheckType type) {
        chk.activateCheck(type, AntiCheatAPI.getCallingClass());
    }

    public static void deactivateCheck(CheckType type) {
        chk.deactivateCheck(type, AntiCheatAPI.getCallingClass());
    }

    public static boolean isActive(CheckType type) {
        return chk.isActive(type);
    }

    public static void exemptPlayer(Player player, CheckType type) {
        chk.exemptPlayer(player, type, AntiCheatAPI.getCallingClass());
    }

    public static void unexemptPlayer(Player player, CheckType type) {
        chk.unexemptPlayer(player, type, AntiCheatAPI.getCallingClass());
    }

    public static boolean isExempt(Player player, CheckType type) {
        return chk.isExempt(player, type);
    }

    public boolean willCheck(Player player, CheckType type) {
        return chk.willCheck(player, type);
    }

    @Deprecated
    public static int getLevel(Player player) {
        return umr.safeGetLevel(player.getName());
    }

    @Deprecated
    public static void setLevel(Player player, int level) {
        umr.safeSetLevel(player.getName(), level);
    }

    public static void resetPlayer(Player player) {
        umr.getUser(player.getName()).resetLevel();
    }

    public static Group getGroup(Player player) {
        return umr.getUser(player.getName()).getGroup();
    }

    public static List<Group> getGroups() {
        return AntiCheatAPI.getManager().getConfiguration().getGroups().getGroups();
    }

    public static boolean isXrayer(Player player) {
        String name = player.getName();
        return xtracker.sufficientData(name) && xtracker.hasAbnormal(name);
    }

    public static AntiCheatManager getManager() {
        return AntiCheat.getManager();
    }

    private static String getCallingClass() {
        return Reflection.getCallerClass((int)2).getName();
    }
}

