/*
 * Decompiled with CFR 0.152.
 */
package net.dynamicdev.anticheat;

import com.comphenix.protocol.ProtocolLibrary;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.dynamicdev.anticheat.command.CommandHandler;
import net.dynamicdev.anticheat.config.Configuration;
import net.dynamicdev.anticheat.event.BlockListener;
import net.dynamicdev.anticheat.event.EntityListener;
import net.dynamicdev.anticheat.event.InventoryListener;
import net.dynamicdev.anticheat.event.PlayerListener;
import net.dynamicdev.anticheat.event.VehicleListener;
import net.dynamicdev.anticheat.manage.AntiCheatManager;
import net.dynamicdev.anticheat.manage.PacketManager;
import net.dynamicdev.anticheat.util.User;
import net.dynamicdev.anticheat.util.Utilities;
import net.dynamicdev.anticheat.xray.XRayListener;
import net.dynamicdev.anticheat.xray.XRayTracker;
import net.gravitydevelopment.updater.Updater;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiCheat
extends JavaPlugin {
    private static AntiCheatManager manager;
    private static AntiCheat plugin;
    private static List<Listener> eventList;
    private static boolean update;
    private static String updateDetails;
    private static Configuration config;
    private static boolean verbose;
    private static boolean developer;
    private static final int PROJECT_ID = 88146;
    private static PacketManager packetManager;
    private static boolean protocolLib;
    private static Long loadTime;

    public void onEnable() {
        plugin = this;
        loadTime = System.currentTimeMillis();
        manager = new AntiCheatManager(this, this.getLogger());
        eventList.add(new PlayerListener());
        eventList.add(new BlockListener());
        eventList.add(new EntityListener());
        eventList.add(new VehicleListener());
        eventList.add(new InventoryListener());
        this.setupConfig();
        this.setupXray();
        this.setupEvents();
        this.setupCommands();
        this.setupUpdater();
        this.setupEnterprise();
        this.restoreLevels();
        Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (Bukkit.getPluginManager().getPlugin("NoCheatPlus") != null) {
                    AntiCheat.this.getLogger().severe("You are also running NoCheatPlus!");
                    AntiCheat.this.getLogger().severe("NoCheatPlus has been known to conflict with AntiCheat's results and create false cheat detections.");
                    AntiCheat.this.getLogger().severe("Please remove or disable NoCheatPlus to silence this warning.");
                }
            }
        }, 40L);
        this.verboseLog("Finished loading.");
    }

    public void onDisable() {
        this.verboseLog("Saving user levels...");
        config.getLevels().saveLevelsFromUsers(AntiCheat.getManager().getUserManager().getUsers());
        AntiCheatManager.close();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.cleanup();
    }

    private void setupProtocol() {
        if (Bukkit.getPluginManager().getPlugin("ProtocolLib") != null) {
            protocolLib = true;
            packetManager = new PacketManager(ProtocolLibrary.getProtocolManager(), this, manager);
            this.verboseLog("Hooked into ProtocolLib");
        }
    }

    private void setupXray() {
        final XRayTracker xtracker = manager.getXRayTracker();
        int time = AntiCheat.config.getConfig().alertXRayInterval.getValue() * 20;
        if (AntiCheat.config.getConfig().checkXRay.getValue().booleanValue()) {
            eventList.add(new XRayListener());
            if (AntiCheat.config.getConfig().alertXRay.getValue().booleanValue()) {
                this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        for (Player player : AntiCheat.this.getServer().getOnlinePlayers()) {
                            String name = player.getName();
                            if (xtracker.hasAlerted(name) || !xtracker.sufficientData(name) || !xtracker.hasAbnormal(name)) continue;
                            ArrayList<String> alert = new ArrayList<String>();
                            alert.add(ChatColor.YELLOW + "[ALERT] " + ChatColor.WHITE + name + ChatColor.YELLOW + " might be using xray.");
                            alert.add(ChatColor.YELLOW + "[ALERT] Please check their xray stats using " + ChatColor.WHITE + "/anticheat xray " + name + ChatColor.YELLOW + ".");
                            Utilities.alert(alert);
                            xtracker.logAlert(name);
                        }
                    }
                }, (long)time, (long)time);
                this.verboseLog("Scheduled the XRay checker.");
            }
        }
    }

    private void setupEvents() {
        for (Listener listener : eventList) {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
            this.verboseLog("Registered events for ".concat(listener.toString().split("@")[0].split(".anticheat.")[1]));
        }
    }

    private void setupCommands() {
        this.getCommand("anticheat").setExecutor((CommandExecutor)new CommandHandler());
        this.verboseLog("Registered commands.");
    }

    private void setupUpdater() {
        if (AntiCheat.config.getConfig().autoUpdate.getValue().booleanValue()) {
            File file = this.getFile();
            AntiCheat plugin = this;
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, new Runnable((Plugin)plugin, file){
                final /* synthetic */ Plugin val$plugin;
                final /* synthetic */ File val$file;
                {
                    this.val$plugin = plugin;
                    this.val$file = file;
                }

                @Override
                public void run() {
                    AntiCheat.this.verboseLog("Checking for a new update...");
                    Updater updater = new Updater(this.val$plugin, 88146, this.val$file, Updater.UpdateType.DEFAULT, false);
                    update = updater.getResult() == Updater.UpdateResult.SUCCESS;
                    AntiCheat.this.verboseLog("Update available: " + update);
                    if (update) {
                        updateDetails = updater.getLatestName() + " for " + updater.getLatestGameVersion();
                    }
                }
            });
        }
    }

    private void setupConfig() {
        config = manager.getConfiguration();
        this.verboseLog("Setup the config.");
    }

    private void setupEnterprise() {
        if (AntiCheat.config.getConfig().enterprise.getValue().booleanValue() && AntiCheat.config.getEnterprise().loggingEnabled.getValue().booleanValue()) {
            AntiCheat.config.getEnterprise().database.cleanEvents();
        }
    }

    private void restoreLevels() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            String name = player.getName();
            User user = new User(name);
            user.setIsWaitingOnLevelSync(true);
            config.getLevels().loadLevelToUser(user);
            manager.getUserManager().addUser(user);
            this.verboseLog("Data for " + name + " loaded");
        }
    }

    public static AntiCheat getPlugin() {
        return plugin;
    }

    public static AntiCheatManager getManager() {
        return manager;
    }

    public static boolean isUpdated() {
        return !update;
    }

    public static String getUpdateDetails() {
        return updateDetails;
    }

    public static String getVersion() {
        return manager.getPlugin().getDescription().getVersion();
    }

    private void cleanup() {
        eventList = null;
        manager = null;
        config = null;
    }

    public static boolean developerMode() {
        return developer;
    }

    public static void setDeveloperMode(boolean b) {
        developer = b;
    }

    public static boolean isUsingProtocolLib() {
        return protocolLib;
    }

    public static void debugLog(final String string) {
        Bukkit.getScheduler().runTask((Plugin)AntiCheat.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (developer) {
                    manager.debugLog("[DEBUG] " + string);
                }
            }
        });
    }

    public void verboseLog(String string) {
        if (verbose) {
            this.getLogger().info(string);
        }
    }

    public void setVerbose(boolean b) {
        verbose = b;
    }

    public Long getLoadTime() {
        return loadTime;
    }

    static {
        eventList = new ArrayList<Listener>();
        update = false;
        updateDetails = null;
        protocolLib = false;
    }
}

