package de.lonzbonz.supportchat.util;

import java.io.File;
import java.io.IOException;

import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

import de.lonzbonz.supportchat.Main;

/**
 * Created by Lonzbonz on 24.01.2015
 */
public class FileManageSystem {
	
	public static File getConfigFile() {
		return new File("plugins/SupportChat", "config.yml");
	}
	
	public static FileConfiguration getConfigFileConfiguration() {
		return YamlConfiguration.loadConfiguration(getConfigFile());
	}
	
	/**
	 * Erstellt die Standart-Werte, falls diese nicht existieren
	 */
	public static boolean createStandardConfig() {
		FileConfiguration cfg = getConfigFileConfiguration();
		
		cfg.options().copyDefaults(true);
		cfg.addDefault("prefix", "&7[&bSupportChat&7]");
		cfg.addDefault("supporterPermission", "supportchat.supporter");
		
		try {
			cfg.save(getConfigFile());
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	/**
	 * Ldt alle angegebenen Werte in die Variablen
	 */
	public static void fetchData() {
		FileConfiguration cfg = getConfigFileConfiguration();
		
		Main.getInstance().prefix = ChatColor.translateAlternateColorCodes('&', cfg.getString("prefix")) + "r ";
		Main.getInstance().supporterPermission = cfg.getString("supporterPermission");
	}

}
