package de.lonzbonz.supportchat.listener;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

import de.lonzbonz.supportchat.Main;

/**
 * Created by Lonzbonz on 24.01.2015
 */
public class PlayerListener implements Listener {

	private Main plugin;
	
	public PlayerListener(Main plugin) {
		this.plugin = plugin;
	}
	
	@EventHandler
	public void onQuit(PlayerQuitEvent e) {
		Player p = e.getPlayer();
		if(plugin.needHelp.contains(p.getName())) {
			plugin.needHelp.remove(p.getName());
		}
		if(plugin.supportChat.containsKey(p.getName())) {
			plugin.supportChat.remove(p.getName());
		}
		if(plugin.supportChat.containsValue(p.getName())) {
			plugin.supportChat.remove(p.getName());
		}
		if(p.hasPermission(plugin.supporterPermission)) {
			if(plugin.onlineSupporters.contains(p.getName())) {
				plugin.onlineSupporters.remove(p.getName());
			}
			e.setQuitMessage("r[bSupporterr] b" + p.getName() + " eleft the server.");
		}
	}
	
	@EventHandler
	public void onJoin(PlayerJoinEvent e) {
		Player p = e.getPlayer();
		if(p.hasPermission(plugin.supporterPermission)) {
			if(!plugin.onlineSupporters.contains(p.getName())) {
				plugin.onlineSupporters.add(p.getName());
			}
			e.setJoinMessage("r[bSupporterr] b" + p.getName() + " ehas joined the server.");
		}
	}
}
