package de.lonzbonz.supportchat.command;

import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

import de.lonzbonz.supportchat.Main;

/**
 * Created by Lonzbonz on 24.01.2015
 */
@SuppressWarnings("deprecation")
public class SupportCommand implements CommandExecutor {

	private Main plugin;
	
	public SupportCommand(Main plugin) {
		this.plugin = plugin;
	}
	
	/*
	 * Syntax:
	 *	//support <accept> <Spieler>
	 * 	//support <close> <Spieler>
	 * 	//support
	 * 	//support <deny> <Spieler>
	 */
	
	@Override
	public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
		if(!(sender instanceof Player)) {
			sender.sendMessage("Du musst ein Spieler sein!");
			return true;
		}
		Player p = (Player) sender;
		if(args.length == 0) {
			if(!plugin.needHelp.contains(p.getName())) {
				plugin.needHelp.add(p.getName());
				p.sendMessage(plugin.prefix + "eDu hast Hilfe angefordert! Warte einen kurzen Moment!");
				for(String suppString : plugin.onlineSupporters) {
					Player supporter = Bukkit.getPlayer(suppString);
					if(supporter == null) return true;
					supporter.sendMessage(plugin.prefix + "c" + p.getName() + " bbentigt Hilfe! a/support accept " + p.getName() + " bum ihm zu helfen!");
				}
			} else {
				p.sendMessage(plugin.prefix + "cDu hast bereits Hilfe angefordert!");
			}
		} else if(args.length == 2) {
			if(p.hasPermission(plugin.supporterPermission)) {
				if(args[0].equalsIgnoreCase("accept")) {
					Player target = Bukkit.getPlayer(args[1]);
					if(target != null) {
						if(plugin.needHelp.contains(target.getName())) {
							if(!plugin.supportChat.containsKey(p.getName())) {
								plugin.needHelp.remove(target.getName());
								plugin.supportChat.put(p.getName(), target.getName());
								plugin.supportChat.put(target.getName(), p.getName());
								target.sendMessage(plugin.prefix + "eDu bist nun in einem Chat mit " + p.getName());
								p.sendMessage(plugin.prefix + "eDu bist nun in einem Chat mit " + target.getName());
							} else {
								p.sendMessage(plugin.prefix + "cDu bist bereits mit einem Spieler im Chat!");
							}
						} else {
							p.sendMessage(plugin.prefix + "cDer Spieler hat keine Hilfe angefordert!");
						}
					} else {
						p.sendMessage(plugin.prefix + "cDer Spieler ist nicht online!");
					}
				} else if(args[0].equalsIgnoreCase("close")) {
					Player target = Bukkit.getPlayer(args[1]);
					if(target != null) {
						if(plugin.supportChat.containsKey(p.getName()) && plugin.supportChat.containsValue(target.getName())) {
							plugin.supportChat.remove(p.getName());
							plugin.supportChat.remove(target.getName());
							target.sendMessage(plugin.prefix + "eDu bist nun nichtmehr im Hilfe-Chat!");
							p.sendMessage(plugin.prefix + "eDu bist nun nichtmehr im Hilfe-Chat!");
						} else {
							p.sendMessage(plugin.prefix + "cDu bist nicht mit diesem Spieler im Chat!");
						}
					} else {
						p.sendMessage(plugin.prefix + "cDer Spieler ist nicht online!");
					}
				} else if(args[0].equalsIgnoreCase("deny")) {
					Player target = Bukkit.getPlayer(args[1]);
					if(target != null) {
						if(plugin.needHelp.contains(target.getName())) {
							plugin.needHelp.remove(target.getName());
							target.sendMessage(plugin.prefix + "eDein Antrag auf Hilfe wurde abgelehnt!");
							p.sendMessage(plugin.prefix + "eDu hast den Antrag von " + target.getName() + " abgelehnt!");
						} else {
							p.sendMessage(plugin.prefix + "cDieser Spieler hat keine Hilfe angefordert!");
						}
					} else {
						p.sendMessage(plugin.prefix + "cDer Spieler ist nicht online!");
					}
				} else {
					p.sendMessage(plugin.prefix + "cFalsche Syntax!");
				}
			} else {
				p.sendMessage(plugin.prefix + "cDu hast keine Permissions!");
			}
		} else {
			p.sendMessage(plugin.prefix + "cFalsche Syntax!");
		}
		
		return true;
	}
}
