package de.lonzbonz.supportchat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

import org.bukkit.plugin.java.JavaPlugin;

import de.lonzbonz.supportchat.command.SupportCommand;
import de.lonzbonz.supportchat.listener.ChatListener;
import de.lonzbonz.supportchat.listener.PlayerListener;
import de.lonzbonz.supportchat.util.FileManageSystem;
import de.lonzbonz.supportchat.util.FileManageSystem;

/**
 * Created by Lonzbonz on 24.01.2015
 */
public class Main extends JavaPlugin {

	@Override
	public void onEnable() {
		instance = this;
		this.registerCommands();
		this.registerEvents();
		FileManageSystem.createStandardConfig();
		FileManageSystem.fetchData();
		System.out.println("[SupportChat] plugin version: " + this.getDescription().getVersion() + " by LONZBONZ enabled!");
	}
	
	@Override
	public void onDisable() {
		System.out.println("[SupportChat] plugin disabled!");
	}
	
	private void registerEvents() {
		this.getServer().getPluginManager().registerEvents(new PlayerListener(this), this);
		this.getServer().getPluginManager().registerEvents(new ChatListener(this), this);
	}
	
	private void registerCommands() {
		getCommand("support").setExecutor(new SupportCommand(this));
	}
	
	public String prefix;
	public static Main instance;
	public String supporterPermission;
	public List<String> needHelp = new LinkedList<String>();
	public List<String> onlineSupporters = new ArrayList<String>();
	public HashMap<String, String> supportChat = new HashMap<>();
	
	/**
	 * Gibt eine Instanz der Hauptklasse zurck
	 */
	public static Main getInstance() {
		return instance;
	}
}
