/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class FeedFlag
extends Handler {
    private long lastFeed = 0L;

    public FeedFlag(Session session) {
        super(session);
    }

    @Override
    public void tick(Player player, ApplicableRegionSet set) {
        long now = System.currentTimeMillis();
        LocalPlayer localPlayer = this.getSession().getPlugin().wrapPlayer(player);
        Integer feedAmount = set.queryValue(localPlayer, DefaultFlag.FEED_AMOUNT);
        Integer feedDelay = set.queryValue(localPlayer, DefaultFlag.FEED_DELAY);
        Integer minHunger = set.queryValue(localPlayer, DefaultFlag.MIN_FOOD);
        Integer maxHunger = set.queryValue(localPlayer, DefaultFlag.MAX_FOOD);
        if (feedAmount == null || feedDelay == null || feedAmount == 0 || feedDelay < 0) {
            return;
        }
        if (feedAmount < 0 && (this.getSession().isInvincible(player) || player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE)) {
            return;
        }
        if (minHunger == null) {
            minHunger = 0;
        }
        if (maxHunger == null) {
            maxHunger = 20;
        }
        minHunger = Math.min(20, minHunger);
        maxHunger = Math.min(20, maxHunger);
        if (player.getFoodLevel() >= maxHunger && feedAmount > 0) {
            return;
        }
        if (feedDelay <= 0) {
            player.setFoodLevel((feedAmount > 0 ? maxHunger : minHunger).intValue());
            player.setSaturation((float)player.getFoodLevel());
            this.lastFeed = now;
        } else if (now - this.lastFeed > (long)(feedDelay * 1000)) {
            player.setFoodLevel(Math.min(maxHunger, Math.max(minHunger, player.getFoodLevel() + feedAmount)));
            player.setSaturation((float)player.getFoodLevel());
            this.lastFeed = now;
        }
    }
}

