/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.managers.storage.file;

import com.google.common.base.Preconditions;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLNode;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.managers.RegionDifference;
import com.sk89q.worldguard.protection.managers.storage.DifferenceSaveException;
import com.sk89q.worldguard.protection.managers.storage.RegionDatabase;
import com.sk89q.worldguard.protection.managers.storage.RegionDatabaseUtils;
import com.sk89q.worldguard.protection.managers.storage.StorageException;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class YamlRegionFile
implements RegionDatabase {
    private static final Logger log = Logger.getLogger(YamlRegionFile.class.getCanonicalName());
    private static final Yaml ERROR_DUMP_YAML;
    private static final String FILE_HEADER = "#\r\n# WorldGuard regions file\r\n#\r\n# WARNING: THIS FILE IS AUTOMATICALLY GENERATED. If you modify this file by\r\n# hand, be aware that A SINGLE MISTYPED CHARACTER CAN CORRUPT THE FILE. If\r\n# WorldGuard is unable to parse the file, your regions will FAIL TO LOAD and\r\n# the contents of this file will reset. Please use a YAML validator such as\r\n# http://yaml-online-parser.appspot.com (for smaller files).\r\n#\r\n# REMEMBER TO KEEP PERIODICAL BACKUPS.\r\n#";
    private final String name;
    private final File file;

    public YamlRegionFile(String name, File file) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)file);
        this.name = name;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<ProtectedRegion> loadAll() throws StorageException {
        HashMap<String, ProtectedRegion> loaded = new HashMap<String, ProtectedRegion>();
        YAMLProcessor config = this.createYamlProcessor(this.file);
        try {
            config.load();
        }
        catch (FileNotFoundException e) {
            return new HashSet<ProtectedRegion>(loaded.values());
        }
        catch (IOException e) {
            throw new StorageException("Failed to load region data from '" + this.file + "'", e);
        }
        Map regionData = config.getNodes("regions");
        if (regionData == null) {
            return Collections.emptySet();
        }
        LinkedHashMap<ProtectedRegion, String> parentSets = new LinkedHashMap<ProtectedRegion, String>();
        for (Map.Entry entry : regionData.entrySet()) {
            String id = (String)entry.getKey();
            YAMLNode node = (YAMLNode)entry.getValue();
            String type = node.getString("type");
            try {
                ProtectedRegion region;
                if (type == null) {
                    log.warning("Undefined region type for region '" + id + "'!\n" + "Here is what the region data looks like:\n\n" + YamlRegionFile.toYamlOutput(((YAMLNode)entry.getValue()).getMap()) + "\n");
                    continue;
                }
                if (type.equals("cuboid")) {
                    Vector pt1 = (Vector)Preconditions.checkNotNull((Object)node.getVector("min"));
                    Vector pt2 = (Vector)Preconditions.checkNotNull((Object)node.getVector("max"));
                    BlockVector min = Vector.getMinimum((Vector)pt1, (Vector)pt2).toBlockVector();
                    BlockVector max = Vector.getMaximum((Vector)pt1, (Vector)pt2).toBlockVector();
                    region = new ProtectedCuboidRegion(id, min, max);
                } else if (type.equals("poly2d")) {
                    Integer minY = (Integer)Preconditions.checkNotNull((Object)node.getInt("min-y"));
                    Integer maxY = (Integer)Preconditions.checkNotNull((Object)node.getInt("max-y"));
                    List points = node.getBlockVector2dList("points", null);
                    region = new ProtectedPolygonalRegion(id, points, minY, maxY);
                } else if (type.equals("global")) {
                    region = new GlobalProtectedRegion(id);
                } else {
                    log.warning("Unknown region type for region '" + id + "'!\n" + "Here is what the region data looks like:\n\n" + YamlRegionFile.toYamlOutput(((YAMLNode)entry.getValue()).getMap()) + "\n");
                    continue;
                }
                Integer priority = (Integer)Preconditions.checkNotNull((Object)node.getInt("priority"));
                region.setPriority(priority);
                this.setFlags(region, node.getNode("flags"));
                region.setOwners(this.parseDomain(node.getNode("owners")));
                region.setMembers(this.parseDomain(node.getNode("members")));
                loaded.put(id, region);
                String parentId = node.getString("parent");
                if (parentId == null) continue;
                parentSets.put(region, parentId);
            }
            catch (NullPointerException e) {
                log.log(Level.WARNING, "Unexpected NullPointerException encountered during parsing for the region '" + id + "'!\n" + "Here is what the region data looks like:\n\n" + YamlRegionFile.toYamlOutput(((YAMLNode)entry.getValue()).getMap()) + "\n\nNote: This region will disappear as a result!", e);
            }
        }
        RegionDatabaseUtils.relinkParents(loaded, parentSets);
        return new HashSet<ProtectedRegion>(loaded.values());
    }

    @Override
    public void saveAll(Set<ProtectedRegion> regions) throws StorageException {
        Preconditions.checkNotNull(regions);
        File tempFile = new File(this.file.getParentFile(), this.file.getName() + ".tmp");
        YAMLProcessor config = this.createYamlProcessor(tempFile);
        config.clear();
        YAMLNode regionsNode = config.addNode("regions");
        Map map = regionsNode.getMap();
        for (ProtectedRegion region : regions) {
            HashMap nodeMap = new HashMap();
            map.put(region.getId(), nodeMap);
            YAMLNode node = new YAMLNode(nodeMap, false);
            if (region instanceof ProtectedCuboidRegion) {
                ProtectedCuboidRegion cuboid = (ProtectedCuboidRegion)region;
                node.setProperty("type", (Object)"cuboid");
                node.setProperty("min", (Object)cuboid.getMinimumPoint());
                node.setProperty("max", (Object)cuboid.getMaximumPoint());
            } else if (region instanceof ProtectedPolygonalRegion) {
                ProtectedPolygonalRegion poly = (ProtectedPolygonalRegion)region;
                node.setProperty("type", (Object)"poly2d");
                node.setProperty("min-y", (Object)poly.getMinimumPoint().getBlockY());
                node.setProperty("max-y", (Object)poly.getMaximumPoint().getBlockY());
                ArrayList points = new ArrayList();
                for (BlockVector2D point : poly.getPoints()) {
                    HashMap<String, Integer> data = new HashMap<String, Integer>();
                    data.put("x", point.getBlockX());
                    data.put("z", point.getBlockZ());
                    points.add(data);
                }
                node.setProperty("points", points);
            } else if (region instanceof GlobalProtectedRegion) {
                node.setProperty("type", (Object)"global");
            } else {
                node.setProperty("type", (Object)region.getClass().getCanonicalName());
            }
            node.setProperty("priority", (Object)region.getPriority());
            node.setProperty("flags", this.getFlagData(region));
            node.setProperty("owners", this.getDomainData(region.getOwners()));
            node.setProperty("members", this.getDomainData(region.getMembers()));
            ProtectedRegion parent = region.getParent();
            if (parent == null) continue;
            node.setProperty("parent", (Object)parent.getId());
        }
        config.setHeader(FILE_HEADER);
        config.save();
        this.file.delete();
        if (!tempFile.renameTo(this.file)) {
            throw new StorageException("Failed to rename temporary regions file to " + this.file.getAbsolutePath());
        }
    }

    @Override
    public void saveChanges(RegionDifference difference) throws DifferenceSaveException {
        throw new DifferenceSaveException("Not supported");
    }

    private DefaultDomain parseDomain(YAMLNode node) {
        if (node == null) {
            return new DefaultDomain();
        }
        DefaultDomain domain = new DefaultDomain();
        for (String name : node.getStringList("players", null)) {
            if (name.isEmpty()) continue;
            domain.addPlayer(name);
        }
        for (String stringId : node.getStringList("unique-ids", null)) {
            try {
                domain.addPlayer(UUID.fromString(stringId));
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "Failed to parse UUID '" + stringId + "'", e);
            }
        }
        for (String name : node.getStringList("groups", null)) {
            if (name.isEmpty()) continue;
            domain.addGroup(name);
        }
        return domain;
    }

    private Map<String, Object> getFlagData(ProtectedRegion region) {
        HashMap<String, Object> flagData = new HashMap<String, Object>();
        for (Map.Entry<Flag<?>, Object> entry : region.getFlags().entrySet()) {
            Flag<?> flag = entry.getKey();
            this.addMarshalledFlag(flagData, flag, entry.getValue());
        }
        return flagData;
    }

    private void setFlags(ProtectedRegion region, YAMLNode flagsData) {
        if (flagsData != null) {
            RegionDatabaseUtils.trySetFlagMap(region, flagsData.getMap());
        }
    }

    private <V> void addMarshalledFlag(Map<String, Object> flagData, Flag<V> flag, Object val) {
        if (val == null) {
            return;
        }
        flagData.put(flag.getName(), flag.marshal(val));
    }

    private Map<String, Object> getDomainData(DefaultDomain domain) {
        HashMap<String, Object> domainData = new HashMap<String, Object>();
        this.setDomainData(domainData, "players", domain.getPlayers());
        this.setDomainData(domainData, "unique-ids", domain.getUniqueIds());
        this.setDomainData(domainData, "groups", domain.getGroups());
        return domainData;
    }

    private void setDomainData(Map<String, Object> domainData, String key, Set<?> domain) {
        if (domain.isEmpty()) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object str : domain) {
            list.add(String.valueOf(str));
        }
        domainData.put(key, list);
    }

    private YAMLProcessor createYamlProcessor(File file) {
        Preconditions.checkNotNull((Object)file);
        return new YAMLProcessor(file, false, YAMLFormat.COMPACT);
    }

    private static String toYamlOutput(Object object) {
        try {
            return ERROR_DUMP_YAML.dump(object).replaceAll("(?m)^", "\t");
        }
        catch (Throwable t) {
            return "<error while dumping object>";
        }
    }

    static {
        DumperOptions options = new DumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.AUTO);
        ERROR_DUMP_YAML = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), options);
    }
}

