/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.util;

import com.sk89q.worldguard.util.Enums;
import javax.annotation.Nullable;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Flying;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.projectiles.ProjectileSource;

public final class Entities {
    private static final EntityType shulkerType = Enums.findByValue(EntityType.class, "SHULKER");
    private static final EntityType armorStandType = Enums.findByValue(EntityType.class, "ARMOR_STAND");
    private static final EntityType tippedArrow = Enums.findByValue(EntityType.class, "TIPPED_ARROW");
    private static final EntityType spectralArrow = Enums.findByValue(EntityType.class, "SPECTRAL_ARROW");

    private Entities() {
    }

    public static boolean isTamed(@Nullable Entity entity) {
        return entity instanceof Tameable && ((Tameable)entity).isTamed();
    }

    public static boolean isTNTBased(Entity entity) {
        return entity instanceof TNTPrimed || entity instanceof ExplosiveMinecart;
    }

    public static boolean isFireball(EntityType type) {
        return type == EntityType.FIREBALL || type == EntityType.SMALL_FIREBALL;
    }

    public static boolean isRiddenOnUse(Entity entity) {
        return entity instanceof Vehicle;
    }

    public static boolean isVehicle(EntityType type) {
        return type == EntityType.BOAT || Entities.isMinecart(type);
    }

    public static boolean isMinecart(EntityType type) {
        return type == EntityType.MINECART || type == EntityType.MINECART_CHEST || type == EntityType.MINECART_COMMAND || type == EntityType.MINECART_FURNACE || type == EntityType.MINECART_HOPPER || type == EntityType.MINECART_MOB_SPAWNER || type == EntityType.MINECART_TNT;
    }

    public static Entity getShooter(Entity entity) {
        while (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            ProjectileSource remover = projectile.getShooter();
            if (remover instanceof Entity && remover != entity) {
                entity = (Entity)remover;
                continue;
            }
            return entity;
        }
        return entity;
    }

    public static boolean isHostile(Entity entity) {
        return entity instanceof Monster || entity instanceof Slime || entity instanceof Flying || entity instanceof EnderDragon || entity.getType() == shulkerType;
    }

    public static boolean isNonHostile(Entity entity) {
        return !Entities.isHostile(entity) && (entity instanceof Creature || entity instanceof WaterMob);
    }

    public static boolean isAmbient(Entity entity) {
        return entity instanceof Ambient;
    }

    public static boolean isNPC(Entity entity) {
        return entity instanceof NPC || entity.hasMetadata("NPC");
    }

    public static boolean isNonPlayerCreature(Entity entity) {
        return entity instanceof LivingEntity && !(entity instanceof Player);
    }

    public static boolean isConsideredBuildingIfUsed(Entity entity) {
        return entity instanceof Hanging || entity.getType() == armorStandType;
    }

    public static boolean isPotionArrow(Entity entity) {
        return entity != null && (entity.getType() == tippedArrow || entity.getType() == spectralArrow);
    }
}

