/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.sk89q.worldguard.blacklist.target.MaterialTarget;
import com.sk89q.worldguard.blacklist.target.Target;
import com.sk89q.worldguard.blacklist.target.TargetMatcher;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;

public class TargetMatcherSet {
    private final Multimap<Integer, TargetMatcher> entries = HashMultimap.create();

    public boolean add(TargetMatcher matcher) {
        Preconditions.checkNotNull((Object)matcher);
        return this.entries.put((Object)matcher.getMatchedTypeId(), (Object)matcher);
    }

    public boolean test(Target target) {
        Collection matchers = this.entries.get((Object)target.getTypeId());
        for (TargetMatcher matcher : matchers) {
            if (!matcher.test(target)) continue;
            return true;
        }
        return false;
    }

    public boolean test(Material material) {
        return this.test(new MaterialTarget(material.getId(), 0));
    }

    public boolean test(Block block) {
        return this.test(new MaterialTarget(block.getTypeId(), block.getData()));
    }

    public boolean test(BlockState state) {
        return this.test(new MaterialTarget(state.getTypeId(), state.getRawData()));
    }

    public boolean test(ItemStack itemStack) {
        return this.test(new MaterialTarget(itemStack.getTypeId(), itemStack.getDurability()));
    }

    public String toString() {
        return this.entries.toString();
    }
}

