/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands.task;

import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.util.profile.Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RegionLister
implements Callable<Integer> {
    private static final Logger log = Logger.getLogger(RegionLister.class.getCanonicalName());
    private final WorldGuardPlugin plugin;
    private final CommandSender sender;
    private final RegionManager manager;
    private OwnerMatcher ownerMatcher;
    private int page;

    public RegionLister(WorldGuardPlugin plugin, RegionManager manager, CommandSender sender) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        Preconditions.checkNotNull((Object)manager);
        Preconditions.checkNotNull((Object)sender);
        this.plugin = plugin;
        this.manager = manager;
        this.sender = sender;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void filterOwnedByPlayer(final Player player) {
        this.ownerMatcher = new OwnerMatcher(){

            @Override
            public String getName() {
                return player.getName();
            }

            @Override
            public boolean isContainedWithin(DefaultDomain domain) throws CommandException {
                return domain.contains(player.getUniqueId());
            }
        };
    }

    public void filterOwnedByName(String name, boolean nameOnly) {
        if (nameOnly) {
            this.filterOwnedByName(name);
        } else {
            this.filterOwnedByProfile(name);
        }
    }

    private void filterOwnedByName(final String name) {
        this.ownerMatcher = new OwnerMatcher(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isContainedWithin(DefaultDomain domain) throws CommandException {
                return domain.contains(name);
            }
        };
    }

    private void filterOwnedByProfile(final String name) {
        this.ownerMatcher = new OwnerMatcher(){
            private UUID uniqueId;

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isContainedWithin(DefaultDomain domain) throws CommandException {
                if (domain.contains(name)) {
                    return true;
                }
                if (this.uniqueId == null) {
                    Profile profile;
                    try {
                        profile = RegionLister.this.plugin.getProfileService().findByName(name);
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Failed UUID lookup of '" + name + "'", e);
                        throw new CommandException("Failed to lookup the UUID of '" + name + "'");
                    }
                    catch (InterruptedException e) {
                        log.log(Level.WARNING, "Failed UUID lookup of '" + name + "'", e);
                        throw new CommandException("The lookup the UUID of '" + name + "' was interrupted");
                    }
                    if (profile == null) {
                        throw new CommandException("A user by the name of '" + name + "' does not seem to exist.");
                    }
                    this.uniqueId = profile.getUniqueId();
                }
                return domain.contains(this.uniqueId);
            }
        };
    }

    @Override
    public Integer call() throws Exception {
        Map<String, ProtectedRegion> regions = this.manager.getRegions();
        ArrayList<RegionListEntry> entries = new ArrayList<RegionListEntry>();
        int index = 0;
        for (String id : regions.keySet()) {
            RegionListEntry entry = new RegionListEntry(id, index++);
            ProtectedRegion region = regions.get(id);
            if (this.ownerMatcher != null) {
                entry.isOwner = this.ownerMatcher.isContainedWithin(region.getOwners());
                entry.isMember = this.ownerMatcher.isContainedWithin(region.getMembers());
                if (!entry.isOwner && !entry.isMember) continue;
            }
            entries.add(entry);
        }
        Collections.sort(entries);
        int totalSize = entries.size();
        int pageSize = 10;
        int pages = (int)Math.ceil((float)totalSize / 10.0f);
        this.sender.sendMessage(ChatColor.RED + (this.ownerMatcher == null ? "Regions (page " : "Regions for " + this.ownerMatcher.getName() + " (page ") + (this.page + 1) + " of " + pages + "):");
        if (this.page < pages) {
            for (int i = this.page * 10; i < this.page * 10 + 10 && i < totalSize; ++i) {
                this.sender.sendMessage(ChatColor.YELLOW.toString() + entries.get(i));
            }
        }
        return this.page;
    }

    private class RegionListEntry
    implements Comparable<RegionListEntry> {
        private final String id;
        private final int index;
        boolean isOwner;
        boolean isMember;

        private RegionListEntry(String id, int index) {
            this.id = id;
            this.index = index;
        }

        @Override
        public int compareTo(RegionListEntry o) {
            if (this.isOwner != o.isOwner) {
                return this.isOwner ? 1 : -1;
            }
            if (this.isMember != o.isMember) {
                return this.isMember ? 1 : -1;
            }
            return this.id.compareTo(o.id);
        }

        public String toString() {
            if (this.isOwner) {
                return this.index + 1 + ". +" + this.id;
            }
            if (this.isMember) {
                return this.index + 1 + ". -" + this.id;
            }
            return this.index + 1 + ". " + this.id;
        }
    }

    private static interface OwnerMatcher {
        public String getName();

        public boolean isContainedWithin(DefaultDomain var1) throws CommandException;
    }
}

