/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands.region;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.commands.AsyncCommandHelper;
import com.sk89q.worldguard.bukkit.commands.region.RegionCommandsBase;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.util.DomainInputResolver;
import java.util.concurrent.Callable;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MemberCommands
extends RegionCommandsBase {
    private final WorldGuardPlugin plugin;

    public MemberCommands(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"addmember", "addmember", "addmem", "am"}, usage="<id> <members...>", flags="nw:", desc="Add a member to a region", min=2)
    public void addMember(CommandContext args, CommandSender sender) throws CommandException {
        MemberCommands.warnAboutSaveFailures(sender);
        World world = MemberCommands.checkWorld(args, sender, 'w');
        String id = args.getString(0);
        RegionManager manager = MemberCommands.checkRegionManager(this.plugin, world);
        ProtectedRegion region = MemberCommands.checkExistingRegion(manager, id, true);
        id = region.getId();
        if (!MemberCommands.getPermissionModel(sender).mayAddMembers(region)) {
            throw new CommandPermissionsException();
        }
        DomainInputResolver resolver = new DomainInputResolver(this.plugin.getProfileService(), args.getParsedPaddedSlice(1, 0));
        resolver.setLocatorPolicy(args.hasFlag('n') ? DomainInputResolver.UserLocatorPolicy.NAME_ONLY : DomainInputResolver.UserLocatorPolicy.UUID_ONLY);
        ListenableFuture future = Futures.transform((ListenableFuture)this.plugin.getExecutorService().submit((Callable)resolver), resolver.createAddAllFunction(region.getMembers()));
        AsyncCommandHelper.wrap(future, this.plugin, sender).formatUsing(region.getId(), world.getName()).registerWithSupervisor("Adding members to the region '%s' on '%s'").sendMessageAfterDelay("(Please wait... querying player names...)").thenRespondWith("Region '%s' updated with new members.", "Failed to add new members");
    }

    @Command(aliases={"addowner", "addowner", "ao"}, usage="<id> <owners...>", flags="nw:", desc="Add an owner to a region", min=2)
    public void addOwner(CommandContext args, CommandSender sender) throws CommandException {
        MemberCommands.warnAboutSaveFailures(sender);
        World world = MemberCommands.checkWorld(args, sender, 'w');
        Player player = null;
        LocalPlayer localPlayer = null;
        if (sender instanceof Player) {
            player = (Player)sender;
            localPlayer = this.plugin.wrapPlayer(player);
        }
        String id = args.getString(0);
        RegionManager manager = MemberCommands.checkRegionManager(this.plugin, world);
        ProtectedRegion region = MemberCommands.checkExistingRegion(manager, id, true);
        id = region.getId();
        Boolean flag = (Boolean)region.getFlag(DefaultFlag.BUYABLE);
        DefaultDomain owners = region.getOwners();
        if (localPlayer != null) {
            if (flag != null && flag.booleanValue() && owners != null && owners.size() == 0) {
                int maxRegionCount;
                if (!this.plugin.hasPermission((CommandSender)player, "worldguard.region.unlimited") && (maxRegionCount = this.plugin.getGlobalStateManager().get(world).getMaxRegionCount(player)) >= 0 && manager.getRegionCountOfPlayer(localPlayer) >= maxRegionCount) {
                    throw new CommandException("You already own the maximum allowed amount of regions.");
                }
                this.plugin.checkPermission(sender, "worldguard.region.addowner.unclaimed." + id.toLowerCase());
            } else if (!MemberCommands.getPermissionModel(sender).mayAddOwners(region)) {
                throw new CommandPermissionsException();
            }
        }
        DomainInputResolver resolver = new DomainInputResolver(this.plugin.getProfileService(), args.getParsedPaddedSlice(1, 0));
        resolver.setLocatorPolicy(args.hasFlag('n') ? DomainInputResolver.UserLocatorPolicy.NAME_ONLY : DomainInputResolver.UserLocatorPolicy.UUID_ONLY);
        ListenableFuture future = Futures.transform((ListenableFuture)this.plugin.getExecutorService().submit((Callable)resolver), resolver.createAddAllFunction(region.getOwners()));
        AsyncCommandHelper.wrap(future, this.plugin, sender).formatUsing(region.getId(), world.getName()).registerWithSupervisor("Adding owners to the region '%s' on '%s'").sendMessageAfterDelay("(Please wait... querying player names...)").thenRespondWith("Region '%s' updated with new owners.", "Failed to add new owners");
    }

    @Command(aliases={"removemember", "remmember", "removemem", "remmem", "rm"}, usage="<id> <owners...>", flags="naw:", desc="Remove an owner to a region", min=1)
    public void removeMember(CommandContext args, CommandSender sender) throws CommandException {
        ListenableFuture future;
        MemberCommands.warnAboutSaveFailures(sender);
        World world = MemberCommands.checkWorld(args, sender, 'w');
        String id = args.getString(0);
        RegionManager manager = MemberCommands.checkRegionManager(this.plugin, world);
        ProtectedRegion region = MemberCommands.checkExistingRegion(manager, id, true);
        if (!MemberCommands.getPermissionModel(sender).mayRemoveMembers(region)) {
            throw new CommandPermissionsException();
        }
        if (args.hasFlag('a')) {
            region.getMembers().removeAll();
            future = Futures.immediateFuture(null);
        } else {
            if (args.argsLength() < 2) {
                throw new CommandException("List some names to remove, or use -a to remove all.");
            }
            DomainInputResolver resolver = new DomainInputResolver(this.plugin.getProfileService(), args.getParsedPaddedSlice(1, 0));
            resolver.setLocatorPolicy(args.hasFlag('n') ? DomainInputResolver.UserLocatorPolicy.NAME_ONLY : DomainInputResolver.UserLocatorPolicy.UUID_AND_NAME);
            future = Futures.transform((ListenableFuture)this.plugin.getExecutorService().submit((Callable)resolver), resolver.createRemoveAllFunction(region.getMembers()));
        }
        AsyncCommandHelper.wrap(future, this.plugin, sender).formatUsing(region.getId(), world.getName()).registerWithSupervisor("Removing members from the region '%s' on '%s'").sendMessageAfterDelay("(Please wait... querying player names...)").thenRespondWith("Region '%s' updated with members removed.", "Failed to remove members");
    }

    @Command(aliases={"removeowner", "remowner", "ro"}, usage="<id> <owners...>", flags="naw:", desc="Remove an owner to a region", min=1)
    public void removeOwner(CommandContext args, CommandSender sender) throws CommandException {
        ListenableFuture future;
        MemberCommands.warnAboutSaveFailures(sender);
        World world = MemberCommands.checkWorld(args, sender, 'w');
        String id = args.getString(0);
        RegionManager manager = MemberCommands.checkRegionManager(this.plugin, world);
        ProtectedRegion region = MemberCommands.checkExistingRegion(manager, id, true);
        if (!MemberCommands.getPermissionModel(sender).mayRemoveOwners(region)) {
            throw new CommandPermissionsException();
        }
        if (args.hasFlag('a')) {
            region.getOwners().removeAll();
            future = Futures.immediateFuture(null);
        } else {
            if (args.argsLength() < 2) {
                throw new CommandException("List some names to remove, or use -a to remove all.");
            }
            DomainInputResolver resolver = new DomainInputResolver(this.plugin.getProfileService(), args.getParsedPaddedSlice(1, 0));
            resolver.setLocatorPolicy(args.hasFlag('n') ? DomainInputResolver.UserLocatorPolicy.NAME_ONLY : DomainInputResolver.UserLocatorPolicy.UUID_AND_NAME);
            future = Futures.transform((ListenableFuture)this.plugin.getExecutorService().submit((Callable)resolver), resolver.createRemoveAllFunction(region.getOwners()));
        }
        AsyncCommandHelper.wrap(future, this.plugin, sender).formatUsing(region.getId(), world.getName()).registerWithSupervisor("Removing owners from the region '%s' on '%s'").sendMessageAfterDelay("(Please wait... querying player names...)").thenRespondWith("Region '%s' updated with owners removed.", "Failed to remove owners");
    }
}

