/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.blacklist.logger;

import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldguard.blacklist.event.BlacklistEvent;
import com.sk89q.worldguard.blacklist.logger.LoggerHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleHandler
implements LoggerHandler {
    private String worldName;
    private final Logger logger;

    public ConsoleHandler(String worldName, Logger logger) {
        this.worldName = worldName;
        this.logger = logger;
    }

    @Override
    public void logEvent(BlacklistEvent event, String comment) {
        this.logger.log(Level.INFO, "[" + this.worldName + "] " + event.getLoggerMessage() + (comment != null ? " (" + comment + ")" : ""));
    }

    private static String getFriendlyItemName(int id) {
        ItemType type = ItemType.fromID((int)id);
        if (type != null) {
            return type.getName() + " (#" + id + ")";
        }
        return "#" + id;
    }

    @Override
    public void close() {
    }
}

