/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer.reflection.resolver;

import java.lang.reflect.Constructor;
import org.inventivetalent.nicknamer.reflection.resolver.MemberResolver;
import org.inventivetalent.nicknamer.reflection.resolver.ResolverQuery;
import org.inventivetalent.nicknamer.reflection.resolver.wrapper.ConstructorWrapper;
import org.inventivetalent.nicknamer.reflection.util.AccessUtil;

public class ConstructorResolver
extends MemberResolver<Constructor> {
    public ConstructorResolver(Class<?> clazz) {
        super(clazz);
    }

    public ConstructorResolver(String className) throws ClassNotFoundException {
        super(className);
    }

    @Override
    public Constructor resolveIndex(int index) throws IndexOutOfBoundsException, ReflectiveOperationException {
        return AccessUtil.setAccessible(this.clazz.getDeclaredConstructors()[index]);
    }

    @Override
    public Constructor resolveIndexSilent(int index) {
        try {
            return this.resolveIndex(index);
        }
        catch (IndexOutOfBoundsException | ReflectiveOperationException exception) {
            return null;
        }
    }

    @Override
    public ConstructorWrapper resolveIndexWrapper(int index) {
        return new ConstructorWrapper(this.resolveIndexSilent(index));
    }

    public ConstructorWrapper resolveWrapper(Class<?>[] ... types) {
        return new ConstructorWrapper(this.resolveSilent(types));
    }

    public Constructor resolveSilent(Class<?>[] ... types) {
        try {
            return this.resolve(types);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Constructor resolve(Class<?>[] ... types) throws NoSuchMethodException {
        ResolverQuery.Builder builder = ResolverQuery.builder();
        for (Class<?>[] type : types) {
            builder.with(type);
        }
        try {
            return (Constructor)super.resolve(builder.build());
        }
        catch (ReflectiveOperationException e) {
            throw (NoSuchMethodException)e;
        }
    }

    @Override
    protected Constructor resolveObject(ResolverQuery query) throws ReflectiveOperationException {
        return AccessUtil.setAccessible(this.clazz.getDeclaredConstructor(query.getTypes()));
    }

    public Constructor resolveFirstConstructor() throws ReflectiveOperationException {
        int n = 0;
        Constructor<?>[] constructorArray = this.clazz.getDeclaredConstructors();
        int n2 = constructorArray.length;
        if (n < n2) {
            Constructor<?> constructor = constructorArray[n];
            return AccessUtil.setAccessible(constructor);
        }
        return null;
    }

    public Constructor resolveFirstConstructorSilent() {
        try {
            return this.resolveFirstConstructor();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Constructor resolveLastConstructor() throws ReflectiveOperationException {
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = this.clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        for (int i = 0; i < n; ++i) {
            Constructor<?> constructor1;
            constructor = constructor1 = constructorArray[i];
        }
        if (constructor != null) {
            return AccessUtil.setAccessible(constructor);
        }
        return null;
    }

    public Constructor resolveLastConstructorSilent() {
        try {
            return this.resolveLastConstructor();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected NoSuchMethodException notFoundException(String joinedNames) {
        return new NoSuchMethodException("Could not resolve constructor for " + joinedNames + " in class " + this.clazz);
    }
}

