/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer.api.event;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class NickNamerUpdateEvent
extends Event
implements Cancellable {
    private final OfflinePlayer player;
    private final Player observer;
    private String nick;
    private String skin;
    private boolean cancelled;
    private static HandlerList handlers = new HandlerList();

    public NickNamerUpdateEvent(OfflinePlayer who, Player observer, String nick, String skin) {
        super(true);
        this.player = who;
        this.observer = observer;
        this.nick = nick;
        this.skin = skin;
    }

    public final Player getPlayer() {
        return this.player.getPlayer();
    }

    @Nonnull
    public final OfflinePlayer getOfflinePlayer() {
        return this.player;
    }

    @Nonnull
    public final Player getObserver() {
        return this.observer;
    }

    @Nullable
    public String getNick() {
        return this.nick;
    }

    public void setNick(@Nullable String nick) {
        if (nick != null && nick.length() > 16) {
            throw new IllegalArgumentException("The name cannot be longer than 16 characters");
        }
        this.nick = nick;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

