/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.nicknamer;

import com.google.common.cache.CacheBuilder;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.PersistenceException;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.inventivetalent.apihelper.APIManager;
import org.inventivetalent.data.async.AsyncDataProvider;
import org.inventivetalent.data.async.DataCallback;
import org.inventivetalent.data.ebean.BeanProvider;
import org.inventivetalent.data.ebean.EbeanDataProvider;
import org.inventivetalent.data.mapper.AsyncCacheMapper;
import org.inventivetalent.data.mapper.AsyncJsonValueMapper;
import org.inventivetalent.data.mapper.AsyncStringValueMapper;
import org.inventivetalent.data.redis.RedisDataProvider;
import org.inventivetalent.data.sql.SQLDataProvider;
import org.inventivetalent.mcwrapper.auth.GameProfileWrapper;
import org.inventivetalent.nicknamer.api.INickNamer;
import org.inventivetalent.nicknamer.api.NickManager;
import org.inventivetalent.nicknamer.api.NickNamerAPI;
import org.inventivetalent.nicknamer.api.PluginNickManager;
import org.inventivetalent.nicknamer.api.SkinLoader;
import org.inventivetalent.nicknamer.api.SkinLoaderBridge;
import org.inventivetalent.nicknamer.api.event.disguise.NickDisguiseEvent;
import org.inventivetalent.nicknamer.api.event.disguise.SkinDisguiseEvent;
import org.inventivetalent.nicknamer.api.event.refresh.PlayerRefreshEvent;
import org.inventivetalent.nicknamer.api.event.replace.ChatInReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.ChatOutReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.ChatReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.ChatTabCompleteReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.NameReplacer;
import org.inventivetalent.nicknamer.api.event.replace.PlayerJoinReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.PlayerQuitReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.ScoreboardReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.ScoreboardScoreReplacementEvent;
import org.inventivetalent.nicknamer.api.event.replace.ScoreboardTeamReplacementEvent;
import org.inventivetalent.nicknamer.api.event.skin.SkinLoadedEvent;
import org.inventivetalent.nicknamer.command.GeneralCommands;
import org.inventivetalent.nicknamer.command.NickCommands;
import org.inventivetalent.nicknamer.command.SkinCommands;
import org.inventivetalent.nicknamer.database.NickEntry;
import org.inventivetalent.nicknamer.database.SkinDataEntry;
import org.inventivetalent.nicknamer.database.SkinEntry;
import org.inventivetalent.nicknamer.mcstats.MetricsLite;
import org.inventivetalent.packetlistener.PacketListenerAPI;
import org.inventivetalent.pluginannotations.PluginAnnotations;
import org.inventivetalent.pluginannotations.config.ConfigValue;
import org.inventivetalent.update.spiget.SpigetUpdate;
import org.inventivetalent.update.spiget.UpdateCallback;
import org.inventivetalent.update.spiget.comparator.VersionComparator;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class NickNamerPlugin
extends JavaPlugin
implements Listener,
PluginMessageListener,
INickNamer {
    public static NickNamerPlugin instance;
    public GeneralCommands generalCommands;
    public NickCommands nickCommands;
    public SkinCommands skinCommands;
    final Executor storageExecutor = Executors.newSingleThreadExecutor();
    @ConfigValue(path="replace.chat.player")
    boolean replaceChatPlayer;
    @ConfigValue(path="replace.chat.out")
    boolean replaceChatOut;
    @ConfigValue(path="replace.chat.in.general")
    boolean replaceChatInGeneral;
    @ConfigValue(path="replace.chat.in.command")
    boolean replaceChatInCommand;
    @ConfigValue(path="replace.scoreboard")
    boolean replaceScoreboard;
    @ConfigValue(path="replace.scoreboardScore")
    boolean replaceScoreboardScore;
    @ConfigValue(path="replace.scoreboardTeam")
    boolean replaceScoreboardTeam;
    @ConfigValue(path="replace.tabComplete.chat")
    boolean replaceTabCompleteChat;
    @ConfigValue(path="updateSelf")
    boolean updateSelf = true;
    public Map<String, Collection<String>> randomNicks = new HashMap<String, Collection<String>>();
    public Map<String, Collection<String>> randomSkins = new HashMap<String, Collection<String>>();
    @ConfigValue(path="random.join.nick")
    public boolean randomJoinNick = false;
    @ConfigValue(path="random.join.skin")
    public boolean randomJoinSkin = false;
    @ConfigValue(path="bungeecord")
    public boolean bungeecord;
    @ConfigValue(path="names.format", colorChar=38)
    public String namesFormat = "%s";
    @ConfigValue(path="names.chatFormat", colorChar=38)
    public String namesChatFormat = "%s\u00a7r";
    @ConfigValue(path="storage.type")
    String storageType = "local";
    @ConfigValue(path="storage.sql.address")
    String sqlAddress;
    @ConfigValue(path="storage.sql.user")
    String sqlUser;
    @ConfigValue(path="storage.sql.pass")
    String sqlPass;
    @ConfigValue(path="storage.redis.host")
    String redisHost;
    @ConfigValue(path="storage.redis.port")
    int redisPort;
    @ConfigValue(path="storage.redis.pass")
    String redisPass;
    @ConfigValue(path="storage.redis.max-connections")
    int redisMaxConnections;
    @ConfigValue(path="pluginFeatures.commands.general")
    boolean featureCommandGeneral = true;
    @ConfigValue(path="pluginFeatures.commands.nick")
    boolean featureCommandNick = true;
    @ConfigValue(path="pluginFeatures.commands.skin")
    boolean featureCommandSkin = true;
    SpigetUpdate spigetUpdate;

    public void onLoad() {
        String javaVersion = System.getProperty("java.version");
        this.getLogger().info("Java Version: " + javaVersion);
        int majorVersion = Integer.parseInt(javaVersion.split("\\.")[1]);
        if (majorVersion < 8) {
            this.getLogger().severe("Please use Java 8 or higher (is " + majorVersion + ")");
            throw new RuntimeException("NickNamer requires Java 8+");
        }
        APIManager.require(PacketListenerAPI.class, (Plugin)this);
        APIManager.registerAPI(new NickNamerAPI(), (Plugin)this);
    }

    public void onEnable() {
        instance = this;
        APIManager.initAPI(PacketListenerAPI.class);
        APIManager.initAPI(NickNamerAPI.class);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.reload();
        if (this.featureCommandGeneral) {
            this.generalCommands = new GeneralCommands(this);
            PluginAnnotations.COMMAND.registerCommands((Plugin)this, this.generalCommands);
        } else {
            this.getLogger().info("General commands disabled");
        }
        if (this.featureCommandNick) {
            this.nickCommands = new NickCommands(this);
            PluginAnnotations.COMMAND.registerCommands((Plugin)this, this.nickCommands);
        } else {
            this.getLogger().info("Nick commands disabled");
        }
        if (this.featureCommandSkin) {
            this.skinCommands = new SkinCommands(this);
            PluginAnnotations.COMMAND.registerCommands((Plugin)this, this.skinCommands);
        } else {
            this.getLogger().info("Skin commands disabled");
        }
        if (this.bungeecord) {
            if (Bukkit.getOnlineMode()) {
                this.getLogger().warning("Bungeecord is enabled, but server is in online mode!");
            }
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "NickNamer", (PluginMessageListener)this);
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "NickNamer");
        }
        new PluginNickManager(this);
        switch (this.storageType.toLowerCase()) {
            case "temporary": {
                this.getLogger().info("Using temporary storage");
                break;
            }
            case "local": {
                this.getLogger().info("Using local storage");
                this.initStorageLocal();
                break;
            }
            case "sql": {
                this.getLogger().info("Using SQL storage (" + this.sqlUser + "@" + this.sqlAddress + ")");
                this.initStorageSQL();
                break;
            }
            case "redis": {
                throw new RuntimeException("Redis storage is currently not supported.");
            }
        }
        try {
            MetricsLite metrics = new MetricsLite((Plugin)this);
            if (metrics.start()) {
                this.getLogger().info("Metrics started");
            }
            this.spigetUpdate = new SpigetUpdate((Plugin)this, 5341).setUserAgent("NickNamer/" + this.getDescription().getVersion()).setVersionComparator(VersionComparator.SEM_VER);
            this.spigetUpdate.checkForUpdate(new UpdateCallback(){

                @Override
                public void updateAvailable(String s, String s1, boolean b) {
                    NickNamerPlugin.this.getLogger().info("A new version is available (" + s + "). Download it from https://r.spiget.org/5341");
                }

                @Override
                public void upToDate() {
                    NickNamerPlugin.this.getLogger().info("The plugin is up-to-date.");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void reload() {
        PluginAnnotations.CONFIG.loadValues((Plugin)this, (Object)this);
        this.parseListOrCategories("random.nick", this.randomNicks);
        this.parseListOrCategories("random.skin", this.randomSkins);
    }

    public void onDisable() {
        APIManager.disableAPI(NickNamerAPI.class);
    }

    <V> AsyncCacheMapper.CachedDataProvider<V> initCache(AsyncDataProvider<V> provider) {
        return AsyncCacheMapper.create(provider, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES), this.storageExecutor);
    }

    void initStorageLocal() {
        int nickCount = -1;
        int skinCount = -1;
        int dataCount = -1;
        try {
            nickCount = this.getDatabase().find(NickEntry.class).findRowCount();
            skinCount = this.getDatabase().find(SkinEntry.class).findRowCount();
            dataCount = this.getDatabase().find(SkinDataEntry.class).findRowCount();
        }
        catch (PersistenceException e) {
            this.getLogger().info("Installing database");
            this.installDDL();
        }
        if (nickCount > 0) {
            this.getLogger().info("Found " + nickCount + " player nick-data in database");
        }
        ((PluginNickManager)NickNamerAPI.getNickManager()).setNickDataProvider(this.initCache(AsyncStringValueMapper.ebean(new EbeanDataProvider<NickEntry>(this.getDatabase(), NickEntry.class), new BeanProvider<NickEntry>(){

            @Override
            public NickEntry provide(String key, String value) {
                return new NickEntry(key, value);
            }
        })));
        if (dataCount > 0) {
            this.getLogger().info("Found " + skinCount + " player skin-data in database");
        }
        ((PluginNickManager)NickNamerAPI.getNickManager()).setSkinDataProvider(this.initCache(AsyncStringValueMapper.ebean(new EbeanDataProvider<SkinEntry>(this.getDatabase(), SkinEntry.class), new BeanProvider<SkinEntry>(){

            @Override
            public SkinEntry provide(String key, String value) {
                return new SkinEntry(key, value);
            }
        })));
        if (dataCount > 0) {
            this.getLogger().info("Found " + dataCount + " skin textures in database");
            for (SkinDataEntry entry : this.getDatabase().find(SkinDataEntry.class).findSet()) {
                if (System.currentTimeMillis() - entry.getLoadTime() <= 3600000L) continue;
                this.getLogger().info("Deleting old skin for " + entry.getKey());
                this.getDatabase().delete((Object)entry);
            }
        }
        SkinLoader.setSkinDataProvider(this.initCache(AsyncJsonValueMapper.ebean(new EbeanDataProvider<SkinDataEntry>(this.getDatabase(), SkinDataEntry.class), new BeanProvider<SkinDataEntry>(){

            @Override
            public SkinDataEntry provide(String key, String value) {
                SkinDataEntry bean = new SkinDataEntry(key, value);
                bean.setLoadTime(System.currentTimeMillis());
                return bean;
            }
        })));
    }

    void initStorageSQL() {
        if (this.sqlPass == null || this.sqlPass.isEmpty()) {
            this.sqlPass = null;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                try {
                    Connection connection = DriverManager.getConnection(NickNamerPlugin.this.sqlAddress, NickNamerPlugin.this.sqlUser, NickNamerPlugin.this.sqlPass);
                    ((PluginNickManager)NickNamerAPI.getNickManager()).setNickDataProvider(NickNamerPlugin.this.initCache(AsyncStringValueMapper.sql(new SQLDataProvider(connection, "nicknamer_data_nick"))));
                    ((PluginNickManager)NickNamerAPI.getNickManager()).setSkinDataProvider(NickNamerPlugin.this.initCache(AsyncStringValueMapper.sql(new SQLDataProvider(connection, "nicknamer_data_skin"))));
                    SkinLoader.setSkinDataProvider(NickNamerPlugin.this.initCache(AsyncJsonValueMapper.sql(new SQLDataProvider(connection, "nicknamer_skins"))));
                }
                catch (SQLException e) {
                    throw new RuntimeException("SQL connection failed", e);
                }
            }
        });
    }

    void initStorageRedis() {
        if (this.redisPass == null || this.redisPass.isEmpty()) {
            this.redisPass = null;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                JedisPoolConfig config = new JedisPoolConfig();
                config.setMaxTotal(NickNamerPlugin.this.redisMaxConnections);
                JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, NickNamerPlugin.this.redisHost, NickNamerPlugin.this.redisPort, 0, NickNamerPlugin.this.redisPass);
                try (final Jedis jedis = pool.getResource();){
                    jedis.ping();
                    NickNamerPlugin.this.getLogger().info("Connected to Redis");
                    ((PluginNickManager)NickNamerAPI.getNickManager()).setNickDataProvider(NickNamerPlugin.this.initCache(AsyncStringValueMapper.redis(new RedisDataProvider(jedis, "nn_data:%s:nick", "nn_data:(.*):nick"))));
                    ((PluginNickManager)NickNamerAPI.getNickManager()).setSkinDataProvider(NickNamerPlugin.this.initCache(AsyncStringValueMapper.redis(new RedisDataProvider(jedis, "nn_data:%s:skin", "nn_data:(.*):skin"))));
                    SkinLoader.setSkinDataProvider(NickNamerPlugin.this.initCache(AsyncJsonValueMapper.redis(new RedisDataProvider(jedis, "nn_skins:%s", "nn_skins:(.\u00fc)"){

                        @Override
                        public void put(@Nonnull String key, @Nonnull String value) {
                            jedis.setex(this.formatKey(key), 3600, value);
                        }
                    })));
                }
                catch (JedisConnectionException e) {
                    pool.destroy();
                    throw new RuntimeException("Failed to connect to Redis", e);
                }
            }
        });
    }

    public List<Class<?>> getDatabaseClasses() {
        ArrayList list = new ArrayList();
        list.add(SkinDataEntry.class);
        list.add(NickEntry.class);
        list.add(SkinEntry.class);
        return list;
    }

    void parseListOrCategories(String path, Map<String, Collection<String>> target) {
        target.clear();
        List randomList = (List)this.getConfig().get(path);
        target.put("__default__", new ArrayList());
        for (Object randomObject : randomList) {
            try {
                if (randomObject instanceof String) {
                    target.get("__default__").add((String)randomObject);
                    continue;
                }
                if (randomObject instanceof Map) {
                    for (Map.Entry entry : ((Map)randomObject).entrySet()) {
                        Collection<String> collection = target.get(entry.getKey());
                        if (collection == null) {
                            collection = new ArrayList<String>();
                        }
                        collection.addAll((List)entry.getValue());
                        target.put((String)entry.getKey(), collection);
                    }
                    continue;
                }
                this.getLogger().warning("Unknown " + path + " entry " + randomObject.getClass());
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Failed to parse " + path + " entry " + randomObject, e);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void on(final NickDisguiseEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.getAPI().isNicked(event.getDisguised().getUniqueId())) {
            event.setNick(this.getAPI().getNick(event.getDisguised().getUniqueId()));
        } else {
            ((PluginNickManager)this.getAPI()).getNick(event.getDisguised().getUniqueId(), new DataCallback<String>(){

                @Override
                public void provide(@Nullable String nick) {
                    if (nick != null && !nick.equals(event.getDisguised().getName())) {
                        NickNamerPlugin.this.getAPI().refreshPlayer(event.getDisguised().getUniqueId());
                    }
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void on(final SkinDisguiseEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.getAPI().hasSkin(event.getDisguised().getUniqueId())) {
            event.setSkin(this.getAPI().getSkin(event.getDisguised().getUniqueId()));
        } else {
            ((PluginNickManager)this.getAPI()).getSkin(event.getDisguised().getUniqueId(), new DataCallback<String>(){

                @Override
                public void provide(final @Nullable String skin) {
                    if (skin != null && !skin.equals(event.getDisguised().getName())) {
                        GameProfileWrapper skinProfile = SkinLoader.getSkinProfile(skin);
                        if (skinProfile == null) {
                            Bukkit.getScheduler().runTaskAsynchronously((Plugin)instance, new Runnable(){

                                @Override
                                public void run() {
                                    SkinLoader.loadSkin(skin);
                                    Bukkit.getScheduler().runTaskLater((Plugin)instance, new Runnable(){

                                        @Override
                                        public void run() {
                                            NickNamerPlugin.this.getAPI().refreshPlayer(event.getDisguised().getUniqueId());
                                        }
                                    }, 10L);
                                }
                            });
                        } else {
                            NickNamerPlugin.this.getAPI().refreshPlayer(event.getDisguised().getUniqueId());
                        }
                    }
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(SkinLoadedEvent event) {
        if (this.bungeecord) {
            if (Bukkit.getOnlinePlayers().isEmpty()) {
                this.getLogger().warning("Cannot send skin data to Bungeecord: no players online");
                return;
            }
            this.sendPluginMessage((Player)Bukkit.getOnlinePlayers().iterator().next(), "data", event.getOwner(), event.getGameProfile().toJson().toString());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void on(PlayerRefreshEvent event) {
        event.setSelf(this.updateSelf);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void on(final AsyncPlayerChatEvent event) {
        if (ChatReplacementEvent.getHandlerList().getRegisteredListeners().length > 0) {
            final String message = event.getMessage();
            Set<String> nickedPlayerNames = NickNamerAPI.getNickedPlayerNames();
            String replacedMessage = NickNamerAPI.replaceNames(message, nickedPlayerNames, new NameReplacer(){

                @Override
                public String replace(String original) {
                    Player player = Bukkit.getPlayer((String)original);
                    if (player != null) {
                        ChatReplacementEvent replacementEvent = new ChatReplacementEvent(player, event.getRecipients(), message, original, original);
                        Bukkit.getPluginManager().callEvent((Event)replacementEvent);
                        if (replacementEvent.isCancelled()) {
                            return original;
                        }
                        return replacementEvent.getReplacement();
                    }
                    return original;
                }
            }, true);
            event.setMessage(replacedMessage);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void on(final PlayerJoinEvent event) {
        if (PlayerJoinReplacementEvent.getHandlerList().getRegisteredListeners().length > 0) {
            final String message = event.getJoinMessage();
            Set<String> nickedPlayerNames = NickNamerAPI.getNickedPlayerNames();
            String replacedMessage = NickNamerAPI.replaceNames(message, nickedPlayerNames, new NameReplacer(){

                @Override
                public String replace(String original) {
                    Player player = Bukkit.getPlayer((String)original);
                    if (player != null) {
                        PlayerJoinReplacementEvent replacementEvent = new PlayerJoinReplacementEvent(player, Bukkit.getOnlinePlayers(), message, original, original);
                        Bukkit.getPluginManager().callEvent((Event)replacementEvent);
                        if (replacementEvent.isCancelled()) {
                            return original;
                        }
                        return replacementEvent.getReplacement();
                    }
                    return original;
                }
            }, true);
            event.setJoinMessage(replacedMessage);
        }
        if (this.randomJoinSkin && event.getPlayer().hasPermission("nicknamer.join.skin")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    String skin = null;
                    for (PermissionAttachmentInfo info : event.getPlayer().getEffectivePermissions()) {
                        if (!info.getValue() || !info.getPermission().startsWith("nicknamer.join.skin.")) continue;
                        if (skin != null) {
                            NickNamerPlugin.this.getLogger().warning(event.getPlayer().getName() + " has multiple join-skin permissions");
                        }
                        skin = info.getPermission().substring("nicknamer.join.skin.".length());
                    }
                    if (skin == null) {
                        event.getPlayer().chat("/randomSkin");
                    } else {
                        event.getPlayer().chat("/changeskin " + skin);
                    }
                }
            }, 10L);
        }
        if (this.randomJoinNick && event.getPlayer().hasPermission("nicknamer.join.nick")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    String name = null;
                    for (PermissionAttachmentInfo info : event.getPlayer().getEffectivePermissions()) {
                        if (!info.getValue() || !info.getPermission().startsWith("nicknamer.join.nick.")) continue;
                        if (name != null) {
                            NickNamerPlugin.this.getLogger().warning(event.getPlayer().getName() + " has multiple join-nick permissions");
                        }
                        name = info.getPermission().substring("nicknamer.join.nick.".length());
                    }
                    if (name == null) {
                        event.getPlayer().chat("/randomNick");
                    } else {
                        String tempName = name;
                        name = "";
                        boolean toUpper = false;
                        for (int i = 0; i < tempName.length(); ++i) {
                            char c = tempName.charAt(i);
                            if (c == '^') {
                                toUpper = true;
                                continue;
                            }
                            if (toUpper) {
                                name = name + Character.toUpperCase(c);
                                toUpper = false;
                                continue;
                            }
                            name = name + c;
                        }
                        if (toUpper) {
                            NickNamerPlugin.this.getLogger().warning("Trailing upper-case identifier in " + event.getPlayer().getName() + "'s permission: " + tempName);
                        }
                        event.getPlayer().chat("/nickname " + name);
                    }
                }
            }, 20L);
        }
        if (event.getPlayer().hasPermission("nicknamer.updatecheck")) {
            this.spigetUpdate.checkForUpdate(new UpdateCallback(){

                @Override
                public void updateAvailable(String s, String s1, boolean b) {
                    event.getPlayer().sendMessage("\u00a7aA new version for \u00a76NickNamer \u00a7ais available (\u00a77v" + s + "\u00a7a). Download it from https://r.spiget.org/5341");
                }

                @Override
                public void upToDate() {
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void on(PlayerQuitEvent event) {
        if (PlayerJoinReplacementEvent.getHandlerList().getRegisteredListeners().length > 0) {
            final String message = event.getQuitMessage();
            Set<String> nickedPlayerNames = NickNamerAPI.getNickedPlayerNames();
            String replacedMessage = NickNamerAPI.replaceNames(message, nickedPlayerNames, new NameReplacer(){

                @Override
                public String replace(String original) {
                    Player player = Bukkit.getPlayer((String)original);
                    if (player != null) {
                        PlayerQuitReplacementEvent replacementEvent = new PlayerQuitReplacementEvent(player, Bukkit.getOnlinePlayers(), message, original, original);
                        Bukkit.getPluginManager().callEvent((Event)replacementEvent);
                        if (replacementEvent.isCancelled()) {
                            return original;
                        }
                        return replacementEvent.getReplacement();
                    }
                    return original;
                }
            }, true);
            event.setQuitMessage(replacedMessage);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void on(PlayerChatTabCompleteEvent event) {
        if (ChatTabCompleteReplacementEvent.getHandlerList().getRegisteredListeners().length > 0) {
            Set<String> nickedPlayerNames = NickNamerAPI.getNickedPlayerNames();
            ListIterator<String> iterator = ((List)event.getTabCompletions()).listIterator();
            while (iterator.hasNext()) {
                final String completion = (String)iterator.next();
                String replacedCompletion = NickNamerAPI.replaceNames(completion, nickedPlayerNames, new NameReplacer(){

                    @Override
                    public String replace(String original) {
                        Player player = Bukkit.getPlayer((String)original);
                        if (player != null) {
                            PlayerQuitReplacementEvent replacementEvent = new PlayerQuitReplacementEvent(player, Bukkit.getOnlinePlayers(), completion, original, original);
                            Bukkit.getPluginManager().callEvent((Event)replacementEvent);
                            if (replacementEvent.isCancelled()) {
                                return original;
                            }
                            return replacementEvent.getReplacement();
                        }
                        return original;
                    }
                }, true);
                iterator.set(ChatColor.stripColor((String)replacedCompletion));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(ChatReplacementEvent event) {
        if (this.replaceChatPlayer && NickNamerAPI.getNickManager().isNicked(event.getDisguised().getUniqueId())) {
            event.setReplacement(String.format(this.namesChatFormat, NickNamerAPI.getNickManager().getNick(event.getDisguised().getUniqueId())));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(ChatOutReplacementEvent event) {
        if (this.replaceChatOut && NickNamerAPI.getNickManager().isNicked(event.getDisguised().getUniqueId())) {
            event.setReplacement(String.format(this.namesChatFormat, NickNamerAPI.getNickManager().getNick(event.getDisguised().getUniqueId())));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(ChatInReplacementEvent event) {
        if (this.replaceChatInGeneral || this.replaceChatInCommand) {
            if (this.replaceChatInCommand && event.getContext().startsWith("/")) {
                if (NickNamerAPI.getNickManager().isNicked(event.getDisguised().getUniqueId())) {
                    event.setReplacement(NickNamerAPI.getNickManager().getNick(event.getDisguised().getUniqueId()));
                }
            } else if (this.replaceChatInGeneral && NickNamerAPI.getNickManager().isNicked(event.getDisguised().getUniqueId())) {
                event.setReplacement(NickNamerAPI.getNickManager().getNick(event.getDisguised().getUniqueId()));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(ScoreboardReplacementEvent event) {
        if (this.replaceScoreboard && NickNamerAPI.getNickManager().isNicked(event.getDisguised().getUniqueId())) {
            event.setReplacement(NickNamerAPI.getNickManager().getNick(event.getDisguised().getUniqueId()));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(ScoreboardScoreReplacementEvent event) {
        if (this.replaceScoreboardScore && NickNamerAPI.getNickManager().isNicked(event.getDisguised().getUniqueId())) {
            event.setReplacement(NickNamerAPI.getNickManager().getNick(event.getDisguised().getUniqueId()));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(ScoreboardTeamReplacementEvent event) {
        if (this.replaceScoreboardTeam && NickNamerAPI.getNickManager().isNicked(event.getDisguised().getUniqueId())) {
            event.setReplacement(NickNamerAPI.getNickManager().getNick(event.getDisguised().getUniqueId()));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(ChatTabCompleteReplacementEvent event) {
        if (this.replaceTabCompleteChat && NickNamerAPI.getNickManager().isNicked(event.getDisguised().getUniqueId())) {
            event.setReplacement(NickNamerAPI.getNickManager().getNick(event.getDisguised().getUniqueId()));
        }
    }

    @Override
    public NickManager getAPI() {
        return NickNamerAPI.getNickManager();
    }

    @Override
    public void sendPluginMessage(Player player, String action, String ... values) {
        if (!this.bungeecord) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(action);
        out.writeUTF(player.getUniqueId().toString());
        for (String s : values) {
            out.writeUTF(s);
        }
        player.sendPluginMessage((Plugin)instance, "NickNamer", out.toByteArray());
    }

    public void onPluginMessageReceived(String s, Player player, byte[] bytes) {
        if (!this.bungeecord) {
            return;
        }
        if ("NickNamer".equals(s)) {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
            String sub = in.readUTF();
            UUID who = UUID.fromString(in.readUTF());
            if ("name".equals(sub)) {
                String name = in.readUTF();
                if (name == null || "reset".equals(name)) {
                    this.getAPI().removeNick(who);
                } else {
                    this.getAPI().setNick(who, name);
                }
            } else if ("skin".equals(sub)) {
                String skin = in.readUTF();
                if (skin == null || "reset".equals(skin)) {
                    this.getAPI().removeSkin(who);
                } else {
                    this.getAPI().setSkin(who, skin);
                }
            } else if ("data".equals(sub)) {
                try {
                    String owner = in.readUTF();
                    JsonObject data = new JsonParser().parse(in.readUTF()).getAsJsonObject();
                    SkinLoaderBridge.getSkinProvider().put(owner, new GameProfileWrapper(data).toJson());
                }
                catch (JsonParseException e) {
                    e.printStackTrace();
                }
            } else {
                this.getLogger().warning("Unknown incoming plugin message: " + sub);
            }
        }
    }
}

