/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.mcwrapper;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.inventivetalent.mcwrapper.ConstructorPopulator;
import org.inventivetalent.nicknamer.reflection.resolver.ClassResolver;
import org.inventivetalent.nicknamer.reflection.resolver.ConstructorResolver;
import org.inventivetalent.nicknamer.reflection.resolver.FieldResolver;
import org.inventivetalent.nicknamer.reflection.resolver.minecraft.NMSClassResolver;
import org.inventivetalent.nicknamer.reflection.resolver.minecraft.OBCClassResolver;
import org.inventivetalent.nicknamer.reflection.resolver.wrapper.ClassWrapper;
import org.inventivetalent.nicknamer.reflection.resolver.wrapper.ConstructorWrapper;
import org.inventivetalent.nicknamer.reflection.resolver.wrapper.FieldWrapper;

public abstract class Wrapper {
    protected static final ClassResolver CLASS_RESOLVER = new ClassResolver();
    protected static final NMSClassResolver NMS_CLASS_RESOLVER = new NMSClassResolver();
    protected static final OBCClassResolver OBC_CLASS_RESOLVER = new OBCClassResolver();
    private final Object handle;
    private final ClassWrapper classWrapper;
    private final Type type;
    protected final FieldResolver fieldResolver;

    public Wrapper(@Nonnull Object handle) {
        this.handle = handle;
        this.classWrapper = new ClassWrapper(handle.getClass());
        this.type = Type.fromPackage(handle.getClass().getName());
        this.fieldResolver = new FieldResolver(handle.getClass());
    }

    public Wrapper(@Nonnull ClassWrapper classWrapper) {
        this.handle = classWrapper.newInstance();
        this.classWrapper = classWrapper;
        this.type = Type.fromPackage(classWrapper.getName());
        this.fieldResolver = new FieldResolver(classWrapper.getClazz());
    }

    public Wrapper(@Nonnull Class<?> clazz) {
        this(new ClassWrapper(clazz));
    }

    public Wrapper(@Nonnull ClassWrapper classWrapper, ConstructorPopulator ... populators) {
        this.classWrapper = classWrapper;
        this.type = Type.fromPackage(classWrapper.getName());
        this.fieldResolver = new FieldResolver(classWrapper.getClazz());
        Class[][] classArray = new Class[populators.length][0];
        for (int i = 0; i < populators.length; ++i) {
            classArray[i] = populators[i].types();
        }
        ConstructorWrapper constructorWrapper = new ConstructorResolver(classWrapper.getClazz()).resolveWrapper(classArray);
        int i = 0;
        for (Object[] objectArray : classArray) {
            if (Arrays.equals(objectArray, constructorWrapper.getParameterTypes())) {
                this.handle = constructorWrapper.newInstance(populators[i].values());
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("no matching constructor found");
    }

    public Wrapper(@Nonnull Class<?> clazz, ConstructorPopulator ... populators) {
        this(new ClassWrapper(clazz), populators);
    }

    public Wrapper(String ... classNames) {
        this(CLASS_RESOLVER.resolveWrapper(classNames));
    }

    public Wrapper(@Nonnull Type type, String ... classNames) {
        this(type.getClassResolver().resolveWrapper(classNames));
    }

    public <T> T getFieldValue(String ... names) {
        FieldWrapper wrapper = this.getFieldResolver().resolveWrapper(names);
        return wrapper != null ? (T)wrapper.get(this.getHandle()) : null;
    }

    public <T> void setFieldValue(T value, String ... names) {
        FieldWrapper wrapper = this.getFieldResolver().resolveWrapper(names);
        if (wrapper != null) {
            wrapper.set(this.getHandle(), value);
        }
    }

    public Type getType() {
        return this.type;
    }

    public FieldResolver getFieldResolver() {
        return this.fieldResolver;
    }

    public Object getHandle() {
        return this.handle;
    }

    public static enum Type {
        GENERAL,
        NMS,
        OBC;


        public static Type fromPackage(String className) {
            if (className.startsWith("net.minecraft.server")) {
                return NMS;
            }
            if (className.startsWith("org.bukkit.craftbukkit")) {
                return OBC;
            }
            return GENERAL;
        }

        public ClassResolver getClassResolver() {
            switch (this) {
                case GENERAL: {
                    return CLASS_RESOLVER;
                }
                case NMS: {
                    return NMS_CLASS_RESOLVER;
                }
                case OBC: {
                    return OBC_CLASS_RESOLVER;
                }
            }
            throw new IllegalStateException();
        }
    }
}

