/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.data.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.inventivetalent.data.async.AbstractAsyncDataProvider;
import org.inventivetalent.data.async.DataCallable;
import org.inventivetalent.data.async.DataCallback;

public class SQLDataProvider
extends AbstractAsyncDataProvider<String> {
    static final String CREATE_TABLE_IF_NOT_EXISTS = "CREATE TABLE IF NOT EXISTS `%s` (`_Key` VARCHAR(255) NOT NULL UNIQUE, `_Value` TEXT);";
    static final String SELECT_VALUE_WHERE_KEY = "SELECT * FROM %1$s WHERE _Key=? LIMIT 1;";
    static final String SELECT_VALUES_IN = "SELECT _Key, _Value FROM %1s WHERE _Key in (?);";
    static final String INSERT_OR_UPDATE = "INSERT INTO %1$s (_Key,_Value) VALUES (?,?) ON DUPLICATE KEY UPDATE _Value=VALUES(_Value);";
    static final String INSERT_MULTIPLE_OR_UPDATE = "INSERT INTO %1$s (_Key,_Value) VALUES%2$s ON DUPLICATE KEY UPDATE _Value=VALUES(_Value);";
    static final String DELETE_WHERE_KEY = "DELETE FROM %1$s WHERE _Key=?;";
    static final String COUNT_WHERE_KEY = "SELECT count(*) FROM %1$s WHERE _Key=?;";
    static final String SELECT_KEYS = "SELECT _Key FROM %1$s;";
    static final String SELECT_ENTRIES = "SELECT _Key, _Value FROM %1$s;";
    static final String COUNT = "SELECT COUNT(*) AS count FROM %1$s;";
    private final Connection connection;
    private final String table;

    public SQLDataProvider(Connection connection, String table) {
        this.connection = connection;
        this.table = table;
        this.createTableIfNotExists();
    }

    public SQLDataProvider(Executor executor, Connection connection, String table) {
        super(executor);
        this.connection = connection;
        this.table = table;
        this.createTableIfNotExists();
    }

    public SQLDataProvider(String host, String user, String pass, String table) throws SQLException {
        this.connection = DriverManager.getConnection(host, user, pass);
        this.table = table;
        this.createTableIfNotExists();
    }

    public SQLDataProvider(Executor executor, String host, String user, String pass, String table) throws SQLException {
        super(executor);
        this.connection = DriverManager.getConnection(host, user, pass);
        this.table = table;
        this.createTableIfNotExists();
    }

    void createTableIfNotExists() {
        this.execute(() -> {
            try {
                this.connection.prepareStatement(String.format(CREATE_TABLE_IF_NOT_EXISTS, this.table)).executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void put(@Nonnull String key, @Nonnull String value) {
        this.execute(() -> {
            try {
                PreparedStatement stmt = this.connection.prepareStatement(String.format(INSERT_OR_UPDATE, this.table));
                stmt.setString(1, key);
                stmt.setString(2, value);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void put(@Nonnull String key, @Nonnull DataCallable<String> valueCallable) {
        this.execute(() -> {
            try {
                PreparedStatement stmt = this.connection.prepareStatement(String.format(INSERT_OR_UPDATE, this.table));
                stmt.setString(1, key);
                stmt.setString(2, (String)valueCallable.provide());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void putAll(@Nonnull Map<String, String> map) {
        this.execute(() -> {
            String arrayString = "";
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    arrayString = arrayString + ", ";
                }
                arrayString = arrayString + "(`" + (String)entry.getKey() + "`, `" + (String)entry.getValue() + "`)";
                first = false;
            }
            try {
                PreparedStatement stmt = this.connection.prepareStatement(String.format(INSERT_MULTIPLE_OR_UPDATE, this.table, arrayString));
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void putAll(@Nonnull DataCallable<Map<String, String>> mapCallable) {
        this.execute(() -> {
            Map map = (Map)mapCallable.provide();
            String arrayString = "";
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    arrayString = arrayString + ", ";
                }
                arrayString = arrayString + "(`" + (String)entry.getKey() + "`, `" + (String)entry.getValue() + "`)";
                first = false;
            }
            try {
                PreparedStatement stmt = this.connection.prepareStatement(String.format(INSERT_MULTIPLE_OR_UPDATE, this.table, arrayString));
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void get(@Nonnull String key, @Nonnull DataCallback<String> callback) {
        this.execute(() -> {
            try {
                PreparedStatement stmt = this.connection.prepareStatement(String.format(SELECT_VALUE_WHERE_KEY, this.table));
                stmt.setString(1, key);
                ResultSet resultSet = stmt.executeQuery();
                if (resultSet.next()) {
                    callback.provide(resultSet.getString("_Value"));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void contains(@Nonnull String key, @Nonnull DataCallback<Boolean> callback) {
        this.execute(() -> {
            try {
                PreparedStatement preparedStatement = this.connection.prepareStatement(String.format(COUNT_WHERE_KEY, this.table));
                preparedStatement.setString(1, key);
                callback.provide(preparedStatement.executeQuery().next());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void remove(@Nonnull String key, @Nonnull DataCallback<String> callback) {
        this.get(key, callback);
        this.remove(key);
    }

    @Override
    public void remove(@Nonnull String key) {
        this.execute(() -> {
            try {
                PreparedStatement preparedStatement = this.connection.prepareStatement(String.format(DELETE_WHERE_KEY, this.table));
                preparedStatement.setString(1, key);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void keys(@Nonnull DataCallback<Collection<String>> callback) {
        this.execute(() -> {
            try {
                HashSet<String> keys = new HashSet<String>();
                ResultSet resultSet = this.connection.prepareStatement(String.format(SELECT_KEYS, this.table)).executeQuery();
                while (resultSet.next()) {
                    keys.add(resultSet.getString("_Key"));
                }
                callback.provide(keys);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void entries(@Nonnull DataCallback<Map<String, String>> callback) {
        this.execute(() -> {
            try {
                HashMap<String, String> entries = new HashMap<String, String>();
                ResultSet resultSet = this.connection.prepareStatement(String.format(SELECT_ENTRIES, this.table)).executeQuery();
                while (resultSet.next()) {
                    entries.put(resultSet.getString("_Key"), resultSet.getString("_Value"));
                }
                callback.provide(entries);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void size(@Nonnull DataCallback<Integer> callback) {
        this.execute(() -> {
            try {
                PreparedStatement stmt = this.connection.prepareStatement(String.format(COUNT, this.table));
                ResultSet resultSet = stmt.executeQuery();
                if (resultSet.next()) {
                    callback.provide(resultSet.getInt("count"));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

