/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.data.mongodb;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mongodb.MongoClient;
import org.bson.Document;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Decoder;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class DocumentParser {
    static final CodecRegistry CODEC_REGISTRY = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry()});
    static final DocumentCodec CODEC = new DocumentCodec(CODEC_REGISTRY, new BsonTypeClassMap());

    public static JsonObject toJson(Document document) {
        if (document == null) {
            return null;
        }
        return new JsonParser().parse(document.toJson((Encoder)CODEC)).getAsJsonObject();
    }

    public static Document toDocument(JsonElement jsonObject) {
        return Document.parse((String)jsonObject.toString(), (Decoder)CODEC);
    }
}

