/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.data.mapper;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.inventivetalent.data.async.AsyncDataProvider;
import org.inventivetalent.data.async.DataCallable;
import org.inventivetalent.data.async.DataCallback;
import org.inventivetalent.data.ebean.BeanProvider;
import org.inventivetalent.data.ebean.EbeanDataProvider;
import org.inventivetalent.data.ebean.KeyValueBean;
import org.inventivetalent.data.mongodb.MongoDbDataProvider;
import org.inventivetalent.data.redis.RedisDataProvider;
import org.inventivetalent.data.sql.SQLDataProvider;

public class AsyncJsonValueMapper {
    public static AsyncDataProvider<JsonObject> mongodb(MongoDbDataProvider provider) {
        return provider;
    }

    public static AsyncDataProvider<JsonObject> redis(RedisDataProvider provider) {
        return new StringToJsonMapper(provider);
    }

    public static AsyncDataProvider<JsonObject> sql(SQLDataProvider provider) {
        return new StringToJsonMapper(provider);
    }

    public static <B extends KeyValueBean> AsyncDataProvider<JsonObject> ebean(final EbeanDataProvider<B> provider, final BeanProvider<B> beanProvider) {
        return new AsyncDataProvider<JsonObject>(){
            final JsonParser parser = new JsonParser();

            @Override
            public void execute(Runnable runnable) {
                provider.execute(runnable);
            }

            @Override
            public Executor getExecutor() {
                return provider.getExecutor();
            }

            B createBean(String key, String value) {
                return beanProvider.provide(key, value);
            }

            @Override
            public void put(@Nonnull String key, @Nonnull JsonObject value) {
                provider.put(key, this.createBean(key, value.toString()));
            }

            @Override
            public void put(final @Nonnull String key, final @Nonnull DataCallable<JsonObject> valueCallable) {
                provider.put(key, new DataCallable<B>(){

                    @Override
                    @Nonnull
                    public B provide() {
                        return this.createBean(key, ((JsonObject)valueCallable.provide()).toString());
                    }
                });
            }

            @Override
            public void putAll(@Nonnull Map<String, JsonObject> map) {
                HashMap beanMap = new HashMap();
                for (Map.Entry<String, JsonObject> entry : map.entrySet()) {
                    beanMap.put(entry.getKey(), this.createBean(entry.getKey(), entry.getValue().toString()));
                }
                provider.putAll(beanMap);
            }

            @Override
            public void putAll(final @Nonnull DataCallable<Map<String, JsonObject>> mapCallable) {
                provider.putAll(new DataCallable<Map<String, B>>(){

                    @Override
                    @Nonnull
                    public Map<String, B> provide() {
                        Map jsonMap = (Map)mapCallable.provide();
                        HashMap beanMap = new HashMap();
                        for (Map.Entry entry : jsonMap.entrySet()) {
                            beanMap.put(entry.getKey(), this.createBean((String)entry.getKey(), ((JsonObject)entry.getValue()).toString()));
                        }
                        return beanMap;
                    }
                });
            }

            @Override
            public void get(@Nonnull String key, @Nonnull DataCallback<JsonObject> callback) {
                provider.get(key, (V keyValueBean) -> callback.provide(keyValueBean != null ? this.parser.parse(keyValueBean.getValue()).getAsJsonObject() : null));
            }

            @Override
            public void contains(@Nonnull String key, @Nonnull DataCallback<Boolean> callback) {
                provider.contains(key, callback);
            }

            @Override
            public void remove(@Nonnull String key, @Nonnull DataCallback<JsonObject> callback) {
                provider.remove(key, (V keyValueBean) -> callback.provide(keyValueBean != null ? this.parser.parse(keyValueBean.getValue()).getAsJsonObject() : null));
            }

            @Override
            public void remove(@Nonnull String key) {
                provider.remove(key);
            }

            @Override
            public void keys(@Nonnull DataCallback<Collection<String>> callback) {
                provider.keys(callback);
            }

            @Override
            public void entries(@Nonnull DataCallback<Map<String, JsonObject>> callback) {
                provider.entries((Map<String, V> stringBMap) -> {
                    HashMap jsonMap = new HashMap();
                    if (stringBMap == null) {
                        callback.provide(jsonMap);
                        return;
                    }
                    for (Map.Entry entry : stringBMap.entrySet()) {
                        jsonMap.put(entry.getKey(), this.parser.parse(((KeyValueBean)entry.getValue()).getValue()).getAsJsonObject());
                    }
                    callback.provide(jsonMap);
                });
            }

            @Override
            public void size(@Nonnull DataCallback<Integer> callback) {
                provider.size(callback);
            }
        };
    }

    static class StringToJsonMapper
    implements AsyncDataProvider<JsonObject> {
        final JsonParser parser = new JsonParser();
        private AsyncDataProvider<String> provider;

        public StringToJsonMapper(AsyncDataProvider<String> provider) {
            this.provider = provider;
        }

        @Override
        public void execute(Runnable runnable) {
            this.provider.execute(runnable);
        }

        @Override
        public Executor getExecutor() {
            return this.provider.getExecutor();
        }

        @Override
        public void put(@Nonnull String key, @Nonnull JsonObject value) {
            this.provider.put(key, value.toString());
        }

        @Override
        public void put(@Nonnull String key, final @Nonnull DataCallable<JsonObject> valueCallable) {
            this.provider.put(key, new DataCallable<String>(){

                @Override
                @Nonnull
                public String provide() {
                    return ((JsonObject)valueCallable.provide()).toString();
                }
            });
        }

        @Override
        public void putAll(@Nonnull Map<String, JsonObject> map) {
            HashMap<String, String> stringMap = new HashMap<String, String>();
            for (Map.Entry<String, JsonObject> entry : map.entrySet()) {
                stringMap.put(entry.getKey(), entry.getValue().toString());
            }
            this.provider.putAll(stringMap);
        }

        @Override
        public void putAll(final @Nonnull DataCallable<Map<String, JsonObject>> mapCallable) {
            this.provider.putAll(new DataCallable<Map<String, String>>(){

                @Override
                @Nonnull
                public Map<String, String> provide() {
                    Map jsonMap = (Map)mapCallable.provide();
                    HashMap<String, String> stringMap = new HashMap<String, String>();
                    for (Map.Entry entry : jsonMap.entrySet()) {
                        stringMap.put((String)entry.getKey(), ((JsonObject)entry.getValue()).toString());
                    }
                    return stringMap;
                }
            });
        }

        @Override
        public void get(@Nonnull String key, @Nonnull DataCallback<JsonObject> callback) {
            this.provider.get(key, (V s) -> callback.provide(this.parser.parse((String)s).getAsJsonObject()));
        }

        @Override
        public void contains(@Nonnull String key, @Nonnull DataCallback<Boolean> callback) {
            this.provider.contains(key, callback);
        }

        @Override
        public void remove(@Nonnull String key, @Nonnull DataCallback<JsonObject> callback) {
            this.provider.remove(key, (V s) -> callback.provide(this.parser.parse((String)s).getAsJsonObject()));
        }

        @Override
        public void remove(@Nonnull String key) {
            this.provider.remove(key);
        }

        @Override
        public void keys(@Nonnull DataCallback<Collection<String>> callback) {
            this.provider.keys(callback);
        }

        @Override
        public void entries(@Nonnull DataCallback<Map<String, JsonObject>> callback) {
            this.provider.entries((Map<String, V> map) -> {
                HashMap jsonMap = new HashMap();
                if (map == null) {
                    callback.provide(jsonMap);
                    return;
                }
                for (Map.Entry entry : map.entrySet()) {
                    jsonMap.put(entry.getKey(), this.parser.parse((String)entry.getValue()).getAsJsonObject());
                }
                callback.provide(jsonMap);
            });
        }

        @Override
        public void size(@Nonnull DataCallback<Integer> callback) {
            this.provider.size(callback);
        }
    }
}

