/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.data.mapper;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.inventivetalent.data.DataProvider;
import org.inventivetalent.data.async.AsyncDataProvider;
import org.inventivetalent.data.async.DataCallable;
import org.inventivetalent.data.async.DataCallback;

public class AsyncCacheMapper {
    public static <V> CachedDataProvider<V> create(AsyncDataProvider<V> provider) {
        return AsyncCacheMapper.create(provider, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder());
    }

    public static <V> CachedDataProvider<V> create(AsyncDataProvider<V> provider, CacheBuilder<Object, Object> cacheBuilder) {
        return AsyncCacheMapper.create(provider, cacheBuilder, Executors.newSingleThreadExecutor());
    }

    public static <V> CachedDataProvider<V> create(final AsyncDataProvider<V> provider, CacheBuilder<Object, Object> cacheBuilder, Executor cacheExecutor) {
        LoadingCache cache = cacheBuilder.build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, Optional<V>>(){

            public Optional<V> load(String key) throws Exception {
                Object[] value = new Object[1];
                CountDownLatch latch = new CountDownLatch(1);
                provider.get(key, v -> {
                    value[0] = v;
                    latch.countDown();
                });
                latch.await(10L, TimeUnit.SECONDS);
                return Optional.fromNullable((Object)value[0]);
            }
        }, (Executor)cacheExecutor));
        return new CachedDataProvider<V>(provider, cache, cacheExecutor);
    }

    public static class CachedDataProvider<V>
    implements AsyncDataProvider<V>,
    DataProvider<V> {
        AsyncDataProvider<V> provider;
        LoadingCache<String, Optional<V>> cache;
        Executor cacheExecutor;

        CachedDataProvider(AsyncDataProvider<V> provider, LoadingCache<String, Optional<V>> cache, Executor cacheExecutor) {
            this.provider = provider;
            this.cache = cache;
            this.cacheExecutor = cacheExecutor;
        }

        @Override
        public void put(@Nonnull String key, @Nonnull V value) {
            this.cache.put((Object)key, (Object)Optional.of(value));
            this.provider.put(key, value);
        }

        @Override
        public void put(@Nonnull String key, @Nonnull DataCallable<V> valueCallable) {
            this.provider.execute(() -> {
                Object value = valueCallable.provide();
                this.cache.put((Object)key, (Object)Optional.of(value));
                this.provider.put(key, value);
            });
        }

        @Override
        public void putAll(@Nonnull Map<String, V> map) {
            HashMap<String, Optional> optionalMap = new HashMap<String, Optional>();
            for (Map.Entry<String, V> entry : map.entrySet()) {
                optionalMap.put(entry.getKey(), Optional.fromNullable(entry.getValue()));
            }
            this.cache.putAll(optionalMap);
        }

        @Override
        public void putAll(@Nonnull DataCallable<Map<String, V>> mapCallable) {
            this.cacheExecutor.execute(() -> {
                Map map = (Map)mapCallable.provide();
                HashMap optionalMap = new HashMap();
                for (Map.Entry entry : map.entrySet()) {
                    optionalMap.put(entry.getKey(), Optional.fromNullable(entry.getValue()));
                }
                this.cache.putAll(optionalMap);
            });
        }

        @Override
        public void get(@Nonnull String key, @Nonnull DataCallback<V> callback) {
            this.cacheExecutor.execute(() -> {
                try {
                    callback.provide(((Optional)this.cache.get((Object)key)).orNull());
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        @Override
        @Nullable
        public V get(@Nonnull String key) {
            Optional value = (Optional)this.cache.getIfPresent((Object)key);
            return (V)(value != null ? value.orNull() : null);
        }

        @Override
        public void contains(@Nonnull String key, @Nonnull DataCallback<Boolean> callback) {
            this.provider.contains(key, callback);
        }

        @Override
        public boolean contains(@Nonnull String key) {
            Optional value = (Optional)this.cache.getIfPresent((Object)key);
            return value != null && value.isPresent();
        }

        @Override
        public void remove(@Nonnull String key, @Nonnull DataCallback<V> callback) {
            this.cache.invalidate((Object)key);
            this.provider.remove(key, callback);
        }

        @Override
        public void remove(@Nonnull String key) {
            this.cache.invalidate((Object)key);
            this.provider.remove(key);
        }

        @Override
        @Nullable
        public V getAndRemove(@Nonnull String key) {
            Optional value = (Optional)this.cache.getIfPresent((Object)key);
            this.cache.invalidate((Object)key);
            this.provider.remove(key);
            return (V)(value != null ? value.orNull() : null);
        }

        @Override
        public void keys(@Nonnull DataCallback<Collection<String>> callback) {
            this.provider.keys(callback);
        }

        @Override
        @Nonnull
        public Collection<String> keys() {
            return this.cache.asMap().keySet();
        }

        @Override
        public void entries(@Nonnull DataCallback<Map<String, V>> callback) {
            this.provider.entries(callback);
        }

        @Override
        @Nonnull
        public Map<String, V> entries() {
            ConcurrentMap optionalMap = this.cache.asMap();
            HashMap map = new HashMap();
            for (Map.Entry entry : optionalMap.entrySet()) {
                map.put(entry.getKey(), ((Optional)entry.getValue()).orNull());
            }
            return map;
        }

        @Override
        public void size(@Nonnull DataCallback<Integer> callback) {
            this.provider.size(callback);
        }

        @Override
        public int size() {
            return (int)this.cache.size();
        }
    }
}

