/*
 * Decompiled with CFR 0.152.
 */
package de.janomine.coloredsigns.utils;

import java.io.File;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    public static String path = "plugins/ColoredSigns";
    public static File configFile = new File(path + File.separator + "config.yml");
    public static YamlConfiguration config;

    private static YamlConfiguration loadConfig() {
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.load(configFile);
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createConfig() {
        new File(path).mkdir();
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                config = Config.loadConfig();
                config.set("Sign_Colors_enabled", (Object)true);
                config.set("PermissionsEx_support", (Object)false);
                config.save(configFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        config = Config.loadConfig();
    }

    public static void reloadConfig() {
        if (!configFile.exists()) {
            Config.createConfig();
        }
        config = Config.loadConfig();
    }

    public static String get(String key) {
        Config.reloadConfig();
        String value = config.getString(key);
        return value;
    }

    public static int readInt(String key) {
        Config.reloadConfig();
        int value = config.getInt(key);
        return value;
    }

    public static boolean readBoolean(String key) {
        Config.reloadConfig();
        boolean value = config.getBoolean(key);
        return value;
    }

    public static World readWorld(String key) {
        Config.reloadConfig();
        World value = (World)config.get(key);
        return value;
    }

    public static double readDouble(String key) {
        Config.reloadConfig();
        double value = config.getDouble(key);
        return value;
    }
}

