/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit.regexperms;

import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.bukkit.CraftBukkitInterface;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.bukkit.regexperms.PEXPermissionSubscriptionMap;
import ru.tehkode.permissions.bukkit.regexperms.PermissibleInjector;
import ru.tehkode.permissions.bukkit.regexperms.PermissiblePEX;
import ru.tehkode.permissions.bukkit.regexperms.PermissionList;
import ru.tehkode.permissions.events.PermissionSystemEvent;

public class RegexPermissions {
    private final PermissionsEx plugin;
    private PermissionList permsList;
    private PEXPermissionSubscriptionMap subscriptionHandler;
    protected static final PermissibleInjector[] injectors = new PermissibleInjector[]{new PermissibleInjector.ClassPresencePermissibleInjector("net.glowstone.entity.GlowHumanEntity", "permissions", true), new PermissibleInjector.ClassPresencePermissibleInjector("org.getspout.server.entity.SpoutHumanEntity", "permissions", true), new PermissibleInjector.ClassNameRegexPermissibleInjector("org.getspout.spout.player.SpoutCraftPlayer", "perm", false, "org\\.getspout\\.spout\\.player\\.SpoutCraftPlayer"), new PermissibleInjector.ClassPresencePermissibleInjector(CraftBukkitInterface.getCBClassName("entity.CraftHumanEntity"), "perm", true)};

    public RegexPermissions(PermissionsEx plugin) {
        this.plugin = plugin;
        this.subscriptionHandler = PEXPermissionSubscriptionMap.inject(plugin, plugin.getServer().getPluginManager());
        this.permsList = PermissionList.inject(plugin.getServer().getPluginManager());
        plugin.getServer().getPluginManager().registerEvents((Listener)new EventListener(), (Plugin)plugin);
        this.injectAllPermissibles();
    }

    public void onDisable() {
        this.subscriptionHandler.uninject();
        this.uninjectAllPermissibles();
    }

    public boolean hasDebugMode() {
        PermissionManager manager = this.plugin.getPermissionsManager();
        return manager != null && manager.isDebug();
    }

    public PermissionList getPermissionList() {
        return this.permsList;
    }

    public void injectPermissible(Player player) {
        if (player.hasPermission("permissionsex.disabled")) {
            return;
        }
        try {
            PermissiblePEX permissible = new PermissiblePEX(player, this.plugin);
            boolean success = false;
            boolean found = false;
            for (PermissibleInjector injector : injectors) {
                if (!injector.isApplicable(player)) continue;
                found = true;
                Permissible oldPerm = injector.inject(player, (Permissible)permissible);
                if (oldPerm == null) continue;
                permissible.setPreviousPermissible(oldPerm);
                success = true;
                break;
            }
            if (!found) {
                this.plugin.getLogger().warning("No Permissible injector found for your server implementation!");
            } else if (!success) {
                this.plugin.getLogger().warning("Unable to inject PEX's permissible for " + player.getName());
            }
            permissible.recalculatePermissions();
            if (success && this.hasDebugMode()) {
                this.plugin.getLogger().info("Permissions handler for " + player.getName() + " successfully injected");
            }
        }
        catch (Throwable e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to inject permissible for " + player.getName(), e);
        }
    }

    private void injectAllPermissibles() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.injectPermissible(player);
        }
    }

    private void uninjectPermissible(Player player) {
        try {
            boolean success = false;
            for (PermissibleInjector injector : injectors) {
                if (!injector.isApplicable(player)) continue;
                Permissible pexPerm = injector.getPermissible(player);
                if (pexPerm instanceof PermissiblePEX) {
                    if (injector.inject(player, ((PermissiblePEX)pexPerm).getPreviousPermissible()) == null) continue;
                    success = true;
                    break;
                }
                success = true;
                break;
            }
            if (!success) {
                this.plugin.getLogger().warning("No Permissible injector found for your server implementation (while uninjecting for " + player.getName() + "!");
            } else if (this.hasDebugMode()) {
                this.plugin.getLogger().info("Permissions handler for " + player.getName() + " successfully uninjected");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void uninjectAllPermissibles() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.uninjectPermissible(player);
        }
    }

    private class EventListener
    implements Listener {
        private EventListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onPlayerLogin(PlayerLoginEvent event) {
            RegexPermissions.this.injectPermissible(event.getPlayer());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPlayerQuit(PlayerQuitEvent event) {
            RegexPermissions.this.uninjectPermissible(event.getPlayer());
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onPermissionSystemEvent(PermissionSystemEvent event) {
            switch (event.getAction()) {
                case REINJECT_PERMISSIBLES: 
                case RELOADED: {
                    RegexPermissions.this.uninjectAllPermissibles();
                    RegexPermissions.this.injectAllPermissibles();
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }
}

