/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.caching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import ru.tehkode.permissions.PermissionsData;

public abstract class CachingData
implements PermissionsData {
    private final Executor executor;
    protected final Object lock;
    private Map<String, List<String>> permissions;
    private Map<String, Map<String, String>> options;
    private Map<String, List<String>> parents;
    private volatile Set<String> worlds;

    public CachingData(Executor executor, Object lock) {
        this.executor = executor;
        this.lock = lock;
    }

    protected void execute(final Runnable run) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CachingData.this.lock;
                synchronized (object) {
                    run.run();
                }
            }
        });
    }

    protected abstract PermissionsData getBackingData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPermissions() {
        Object object = this.lock;
        synchronized (object) {
            this.permissions = new HashMap<String, List<String>>(this.getBackingData().getPermissionsMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadOptions() {
        Object object = this.lock;
        synchronized (object) {
            this.options = new HashMap<String, Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> e : this.getBackingData().getOptionsMap().entrySet()) {
                this.options.put(e.getKey(), new HashMap<String, String>(e.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInheritance() {
        Object object = this.lock;
        synchronized (object) {
            this.parents = new HashMap<String, List<String>>(this.getBackingData().getParentsMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Object object = this.lock;
        synchronized (object) {
            this.permissions = null;
            this.options = null;
            this.parents = null;
            this.clearWorldsCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        Object object = this.lock;
        synchronized (object) {
            this.getBackingData().load();
            this.loadInheritance();
            this.loadOptions();
            this.loadPermissions();
        }
    }

    @Override
    public String getIdentifier() {
        return this.getBackingData().getIdentifier();
    }

    @Override
    public List<String> getPermissions(String worldName) {
        List<String> ret;
        if (this.permissions == null) {
            this.loadPermissions();
        }
        return (ret = this.permissions.get(worldName)) == null ? Collections.emptyList() : Collections.unmodifiableList(ret);
    }

    @Override
    public void setPermissions(List<String> permissions, final String worldName) {
        if (this.permissions == null) {
            this.loadPermissions();
        }
        final ArrayList<String> safePermissions = new ArrayList<String>(permissions);
        this.execute(new Runnable(){

            @Override
            public void run() {
                CachingData.this.clearWorldsCache();
                CachingData.this.getBackingData().setPermissions(safePermissions, worldName);
            }
        });
        this.permissions.put(worldName, safePermissions);
    }

    @Override
    public Map<String, List<String>> getPermissionsMap() {
        if (this.permissions == null) {
            this.loadPermissions();
        }
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> e : this.permissions.entrySet()) {
            ret.put(e.getKey(), Collections.unmodifiableList(e.getValue()));
        }
        return Collections.unmodifiableMap(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getWorlds() {
        Set<String> worlds = this.worlds;
        if (worlds == null) {
            Object object = this.lock;
            synchronized (object) {
                this.worlds = worlds = this.getBackingData().getWorlds();
            }
        }
        return worlds;
    }

    protected void clearWorldsCache() {
        this.worlds = null;
    }

    @Override
    public String getOption(String option, String worldName) {
        Map<String, String> worldOpts;
        if (this.options == null) {
            this.loadOptions();
        }
        if ((worldOpts = this.options.get(worldName)) == null) {
            return null;
        }
        return worldOpts.get(option);
    }

    @Override
    public void setOption(final String option, final String value, final String world) {
        if (this.options == null) {
            this.loadOptions();
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                CachingData.this.getBackingData().setOption(option, value, world);
            }
        });
        if (this.options != null) {
            Map<String, String> optionsMap = this.options.get(world);
            if (optionsMap == null) {
                optionsMap = new HashMap<String, String>();
                this.options.put(world, optionsMap);
                this.clearWorldsCache();
            }
            if (value == null) {
                optionsMap.remove(option);
            } else {
                optionsMap.put(option, value);
            }
        }
    }

    @Override
    public Map<String, String> getOptions(String worldName) {
        Map<String, String> opts;
        if (this.options == null) {
            this.loadOptions();
        }
        return (opts = this.options.get(worldName)) == null ? Collections.emptyMap() : Collections.unmodifiableMap(opts);
    }

    @Override
    public Map<String, Map<String, String>> getOptionsMap() {
        if (this.options == null) {
            this.loadOptions();
        }
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> e : this.options.entrySet()) {
            ret.put(e.getKey(), Collections.unmodifiableMap(e.getValue()));
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public List<String> getParents(String worldName) {
        List<String> worldParents;
        if (this.parents == null) {
            this.loadInheritance();
        }
        return (worldParents = this.parents.get(worldName)) == null ? Collections.emptyList() : worldParents;
    }

    @Override
    public void setParents(List<String> rawParents, final String worldName) {
        if (this.parents == null) {
            this.loadInheritance();
        }
        final ArrayList<String> safeParents = new ArrayList<String>(rawParents);
        this.execute(new Runnable(){

            @Override
            public void run() {
                CachingData.this.getBackingData().setParents(safeParents, worldName);
            }
        });
        this.parents.put(worldName, Collections.unmodifiableList(safeParents));
    }

    @Override
    public boolean isVirtual() {
        return this.getBackingData().isVirtual();
    }

    @Override
    public void save() {
        this.execute(new Runnable(){

            @Override
            public void run() {
                CachingData.this.getBackingData().save();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Object object = this.lock;
        synchronized (object) {
            this.getBackingData().remove();
            this.clearCache();
        }
    }

    @Override
    public Map<String, List<String>> getParentsMap() {
        if (this.parents == null) {
            this.loadInheritance();
        }
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> e : this.parents.entrySet()) {
            ret.put(e.getKey(), Collections.unmodifiableList(e.getValue()));
        }
        return Collections.unmodifiableMap(ret);
    }
}

