/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.events.PermissionEntityEvent;
import ru.tehkode.permissions.exceptions.RankingException;

public class PermissionUser
extends PermissionEntity {
    private static final String PERMISSION_NOT_FOUND = "<not found>";
    private final PermissionsUserData data;
    protected Map<String, List<PermissionGroup>> cachedGroups = new HashMap<String, List<PermissionGroup>>();
    protected Map<String, List<String>> cachedPermissions = new HashMap<String, List<String>>();
    protected Map<String, String> cachedPrefix = new HashMap<String, String>();
    protected Map<String, String> cachedSuffix = new HashMap<String, String>();
    protected Map<String, String> cachedAnwsers = new ConcurrentHashMap<String, String>();
    protected Map<String, String> cachedOptions = new HashMap<String, String>();

    public PermissionUser(String playerName, PermissionsUserData data, PermissionManager manager) {
        super(playerName, manager);
        this.data = data;
    }

    @Override
    protected PermissionsUserData getData() {
        return this.data;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.manager.shouldCreateUserRecords() && this.isVirtual()) {
            this.getData().setParents(this.getOwnParentIdentifiers(null), null);
        }
        this.updateTimedGroups();
        if (this.isDebug()) {
            this.manager.getLogger().info("User " + this.getIdentifier() + " initialized");
        }
    }

    @Override
    public String getName() {
        Player player;
        String name = this.getOwnOption("name", null, null);
        if (name == null && (player = this.getPlayer()) != null) {
            name = player.getName();
            this.setOption("name", name);
            return name;
        }
        return super.getName();
    }

    @Override
    public PermissionEntity.Type getType() {
        return PermissionEntity.Type.USER;
    }

    @Override
    public String getOption(String optionName, String worldName, String defaultValue) {
        String cacheIndex = worldName + "|" + optionName;
        if (this.cachedOptions.containsKey(cacheIndex)) {
            return this.cachedOptions.get(cacheIndex);
        }
        String value = super.getOption(optionName, worldName, null);
        if (value != null) {
            this.cachedOptions.put(cacheIndex, value);
            return value;
        }
        return defaultValue;
    }

    @Override
    protected List<PermissionGroup> getParentsInternal(String worldName) {
        if (!this.cachedGroups.containsKey(worldName)) {
            List<PermissionGroup> groups = super.getParentsInternal(worldName);
            if (groups.isEmpty()) {
                groups.addAll(this.manager.getDefaultGroups(worldName));
                Collections.sort(groups);
            }
            this.cachedGroups.put(worldName, groups);
        }
        return this.cachedGroups.get(worldName);
    }

    @Deprecated
    public Map<String, List<PermissionGroup>> getAllGroups() {
        return this.getAllParents();
    }

    public void addGroup(String groupName, String worldName) {
        if (groupName == null || groupName.isEmpty()) {
            return;
        }
        ArrayList<String> groups = new ArrayList<String>(this.getOwnParentIdentifiers(worldName));
        if (groups.contains(groupName)) {
            return;
        }
        if (this.manager.userAddGroupsLast) {
            groups.add(groupName);
        } else {
            groups.add(0, groupName);
        }
        this.setParentsIdentifier(groups, worldName);
    }

    public void addGroup(String groupName) {
        this.addGroup(groupName, null);
    }

    public void addGroup(PermissionGroup group, String worldName) {
        if (group == null) {
            return;
        }
        this.addGroup(group.getIdentifier(), worldName);
    }

    public void addGroup(PermissionGroup group) {
        this.addGroup(group, null);
    }

    public void addGroup(String groupName, String worldName, long lifetime) {
        this.addGroup(groupName, worldName);
        if (lifetime > 0L) {
            this.setOption("group-" + groupName + "-until", Long.toString(System.currentTimeMillis() / 1000L + lifetime), worldName);
            this.updateTimedGroups();
        }
    }

    public void removeGroup(String groupName, String worldName) {
        if (groupName == null || groupName.isEmpty()) {
            return;
        }
        ArrayList<String> groups = new ArrayList<String>(this.getOwnParentIdentifiers(worldName));
        if (!groups.contains(groupName)) {
            return;
        }
        groups.remove(groupName);
        this.setParentsIdentifier(groups, worldName);
    }

    public void removeGroup(String groupName) {
        this.removeGroup(this.manager.getGroup(groupName));
    }

    public void removeGroup(PermissionGroup group, String worldName) {
        if (group == null) {
            return;
        }
        this.removeGroup(group.getIdentifier(), worldName);
    }

    public void removeGroup(PermissionGroup group) {
        for (String worldName : this.getWorlds()) {
            this.removeGroup(group, worldName);
        }
        this.removeGroup(group, null);
    }

    public boolean inGroup(PermissionGroup group, String worldName, boolean checkInheritance) {
        for (PermissionGroup parentGroup : this.getParents(worldName)) {
            if (parentGroup.equals(group)) {
                return true;
            }
            if (!checkInheritance || !parentGroup.isChildOf(group, worldName, true)) continue;
            return true;
        }
        return false;
    }

    public boolean inGroup(PermissionGroup group, boolean checkInheritance) {
        for (String worldName : this.getWorlds()) {
            if (!this.inGroup(group, worldName, checkInheritance)) continue;
            return true;
        }
        return this.inGroup(group, null, checkInheritance);
    }

    public boolean inGroup(String groupName, String worldName, boolean checkInheritance) {
        return this.inGroup(this.manager.getGroup(groupName), worldName, checkInheritance);
    }

    public boolean inGroup(String groupName, boolean checkInheritance) {
        return this.inGroup(this.manager.getGroup(groupName), checkInheritance);
    }

    public boolean inGroup(PermissionGroup group, String worldName) {
        return this.inGroup(group, worldName, true);
    }

    public boolean inGroup(PermissionGroup group) {
        return this.inGroup(group, true);
    }

    public boolean inGroup(String groupName, String worldName) {
        return this.inGroup(this.manager.getGroup(groupName), worldName, true);
    }

    public boolean inGroup(String groupName) {
        return this.inGroup(groupName, true);
    }

    public PermissionGroup promote(PermissionUser promoter, String ladderName) throws RankingException {
        if (ladderName == null || ladderName.isEmpty()) {
            ladderName = "default";
        }
        int promoterRank = this.getPromoterRankAndCheck(promoter, ladderName);
        int rank = this.getRank(ladderName);
        PermissionGroup sourceGroup = this.getRankLadders().get(ladderName);
        PermissionGroup targetGroup = null;
        for (Map.Entry<Integer, PermissionGroup> entry : this.manager.getRankLadder(ladderName).entrySet()) {
            int groupRank = entry.getValue().getRank();
            if (groupRank >= rank || groupRank <= promoterRank || targetGroup != null && groupRank <= targetGroup.getRank()) continue;
            targetGroup = entry.getValue();
        }
        if (targetGroup == null) {
            throw new RankingException("User are not promoteable", this, promoter);
        }
        this.swapGroups(sourceGroup, targetGroup);
        this.callEvent(PermissionEntityEvent.Action.RANK_CHANGED);
        return targetGroup;
    }

    public PermissionGroup demote(PermissionUser demoter, String ladderName) throws RankingException {
        if (ladderName == null || ladderName.isEmpty()) {
            ladderName = "default";
        }
        int promoterRank = this.getPromoterRankAndCheck(demoter, ladderName);
        int rank = this.getRank(ladderName);
        PermissionGroup sourceGroup = this.getRankLadders().get(ladderName);
        PermissionGroup targetGroup = null;
        for (Map.Entry<Integer, PermissionGroup> entry : this.manager.getRankLadder(ladderName).entrySet()) {
            int groupRank = entry.getValue().getRank();
            if (groupRank <= rank || groupRank <= promoterRank || targetGroup != null && groupRank >= targetGroup.getRank()) continue;
            targetGroup = entry.getValue();
        }
        if (targetGroup == null) {
            throw new RankingException("User are not demoteable", this, demoter);
        }
        this.swapGroups(sourceGroup, targetGroup);
        this.callEvent(PermissionEntityEvent.Action.RANK_CHANGED);
        return targetGroup;
    }

    public boolean isRanked(String ladder) {
        return this.getRank(ladder) > 0;
    }

    public int getRank(String ladder) {
        Map<String, PermissionGroup> ladders = this.getRankLadders();
        if (ladders.containsKey(ladder)) {
            return ladders.get(ladder).getRank();
        }
        return 0;
    }

    public PermissionGroup getRankLadderGroup(String ladder) {
        if (ladder == null || ladder.isEmpty()) {
            ladder = "default";
        }
        return this.getRankLadders().get(ladder);
    }

    public Map<String, PermissionGroup> getRankLadders() {
        HashMap<String, PermissionGroup> ladders = new HashMap<String, PermissionGroup>();
        for (PermissionGroup group : this.getParents()) {
            if (!group.isRanked()) continue;
            ladders.put(group.getRankLadder(), group);
        }
        return ladders;
    }

    @Override
    public List<String> getPermissions(String worldName) {
        if (!this.cachedPermissions.containsKey(worldName)) {
            this.cachedPermissions.put(worldName, super.getPermissions(worldName));
        }
        return this.cachedPermissions.get(worldName);
    }

    protected int getPromoterRankAndCheck(PermissionUser promoter, String ladderName) throws RankingException {
        if (!this.isRanked(ladderName)) {
            throw new RankingException("User are not in this ladder", this, promoter);
        }
        int rank = this.getRank(ladderName);
        int promoterRank = 0;
        if (promoter != null && promoter.isRanked(ladderName) && (promoterRank = promoter.getRank(ladderName)) >= rank) {
            throw new RankingException("Promoter don't have high enough rank to change " + this.getIdentifier() + "/" + this.getName() + "'s rank", this, promoter);
        }
        return promoterRank;
    }

    protected void swapGroups(PermissionGroup src, PermissionGroup dst) {
        Validate.notNull((Object)src);
        Validate.notNull((Object)dst);
        ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>(this.getParents());
        int indexOfSrcGroup = groups.indexOf(src);
        Validate.isTrue((indexOfSrcGroup != -1 ? 1 : 0) != 0);
        groups.set(indexOfSrcGroup, dst);
        this.setParents(groups);
    }

    @Override
    public String getPrefix(String worldName) {
        if (!this.cachedPrefix.containsKey(worldName)) {
            this.cachedPrefix.put(worldName, super.getPrefix(worldName));
        }
        return this.cachedPrefix.get(worldName);
    }

    @Override
    public boolean has(String permission) {
        Player player = this.getPlayer();
        if (player != null) {
            return this.has(permission, player.getWorld().getName());
        }
        return super.has(permission);
    }

    public Player getPlayer() {
        try {
            return Bukkit.getServer().getPlayer(UUID.fromString(this.getIdentifier()));
        }
        catch (Throwable ex) {
            return Bukkit.getServer().getPlayerExact(this.getIdentifier());
        }
    }

    @Override
    public String getSuffix(String worldName) {
        if (!this.cachedSuffix.containsKey(worldName)) {
            this.cachedSuffix.put(worldName, super.getSuffix(worldName));
        }
        return this.cachedSuffix.get(worldName);
    }

    @Override
    public String getMatchingExpression(String permission, String world) {
        String result;
        String cacheId = world + ":" + permission;
        if (!this.cachedAnwsers.containsKey(cacheId)) {
            result = super.getMatchingExpression(permission, world);
            if (result == null) {
                result = PERMISSION_NOT_FOUND;
            }
            this.cachedAnwsers.put(cacheId, result);
        }
        if (PERMISSION_NOT_FOUND.equals(result = this.cachedAnwsers.get(cacheId))) {
            result = null;
        }
        return result;
    }

    @Override
    protected void clearCache() {
        this.cachedPrefix.clear();
        this.cachedSuffix.clear();
        this.cachedGroups.clear();
        this.cachedPermissions.clear();
        this.cachedAnwsers.clear();
        this.cachedOptions.clear();
    }

    @Override
    public boolean explainExpression(String expression) {
        Player player;
        if (expression == null && this.manager.allowOps && (player = this.getPlayer()) != null && player.isOp()) {
            return true;
        }
        return super.explainExpression(expression);
    }

    protected void updateTimedGroups() {
        long nextExpiration = Long.MAX_VALUE;
        HashSet<Map.Entry> removeGroups = new HashSet<Map.Entry>();
        for (Map.Entry<String, Map<String, String>> entry : this.getAllOptions().entrySet()) {
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                String group = PermissionUser.getTimedGroupName(entry2.getKey());
                if (group == null) continue;
                long groupLifetime = Long.parseLong(entry2.getValue());
                if (groupLifetime > 0L && groupLifetime <= System.currentTimeMillis() / 1000L) {
                    removeGroups.add(Maps.immutableEntry((Object)group, (Object)entry.getKey()));
                    continue;
                }
                nextExpiration = Math.min(nextExpiration, groupLifetime);
            }
        }
        for (Map.Entry<String, Map<String, String>> entry : removeGroups) {
            this.setOption("group-" + entry.getKey() + "-until", null, (String)((Object)entry.getValue()));
            this.removeGroup(entry.getKey(), (String)((Object)entry.getValue()));
            if (!this.isDebug()) continue;
            this.manager.getLogger().log(Level.INFO, entry.getValue() != null ? "Timed group '{0}' in world '{1}' expired from user {2}/{3}" : "Timed group {0} expired from user {2}/{3}", new Object[]{entry.getKey(), entry.getValue(), this.getIdentifier(), this.getName()});
        }
        if (nextExpiration < Long.MAX_VALUE) {
            this.manager.scheduleTimedGroupsCheck(nextExpiration, this.getIdentifier());
        }
    }

    static String getTimedGroupName(String option) {
        if (!option.startsWith("group-") && !option.endsWith("-until")) {
            return null;
        }
        return option.substring("group-".length(), option.length() - "-until".length());
    }

    @Deprecated
    public String[] getGroupsNames() {
        return this.getGroupsNames(null);
    }

    @Deprecated
    public String[] getGroupsNames(String world) {
        return this.getParentIdentifiers(world).toArray(new String[0]);
    }

    @Deprecated
    public PermissionGroup[] getGroups() {
        return this.getParents().toArray(new PermissionGroup[0]);
    }

    @Deprecated
    public PermissionGroup[] getGroups(String worldName) {
        return this.getParents(worldName).toArray(new PermissionGroup[0]);
    }

    @Deprecated
    public String[] getGroupNames() {
        return this.getParentIdentifiers().toArray(new String[0]);
    }

    @Deprecated
    public String[] getGroupNames(String worldName) {
        return this.getParentIdentifiers(worldName).toArray(new String[0]);
    }

    @Deprecated
    public void setGroups(String[] groups, String worldName) {
        this.setParentsIdentifier(Arrays.asList(groups), worldName);
    }

    @Deprecated
    public void setGroups(String[] groups) {
        this.setParentsIdentifier(Arrays.asList(groups));
    }

    @Deprecated
    public void setGroups(PermissionGroup[] parentGroups, String worldName) {
        this.setParents(Arrays.asList(parentGroups), worldName);
    }

    @Deprecated
    public void setGroups(PermissionGroup[] parentGroups) {
        this.setParents(Arrays.asList(parentGroups));
    }
}

