/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.data.bukkit;

import codecrafter47.bungeetablistplus.data.AbstractDataAccess;
import codecrafter47.bungeetablistplus.data.DataKey;
import java.util.ConcurrentModificationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class AbstractBukkitDataAccess<B>
extends AbstractDataAccess<B> {
    protected final Logger logger;
    private final Plugin plugin;

    public AbstractBukkitDataAccess(Logger logger, Plugin plugin) {
        this.logger = logger;
        this.plugin = plugin;
    }

    @Override
    public <V> V getRawValue(DataKey<V> key, B context) {
        try {
            return super.getRawValue(key, context);
        }
        catch (Throwable th) {
            if (!Bukkit.isPrimaryThread() && this.isAsyncOpError(th)) {
                try {
                    return Bukkit.getScheduler().callSyncMethod(this.plugin, () -> this.getRawValue(key, context)).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.logger.log(Level.SEVERE, "Unexpected exception", e);
                }
            }
            this.logger.log(Level.SEVERE, "Unexpected exception", th);
            return null;
        }
    }

    private boolean isAsyncOpError(Throwable th) {
        return th instanceof ConcurrentModificationException || th.getStackTrace()[0].getClassName().equals("org.spigotmc.AsyncCatcher") || th.getCause() != null && this.isAsyncOpError(th.getCause());
    }
}

