/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.data;

import codecrafter47.bungeetablistplus.data.DataKey;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class DataCache {
    private final Map<DataKey<?>, Object> cache = new ConcurrentHashMap();
    private final Multimap<DataKey<?>, Consumer<?>> listeners = Multimaps.synchronizedMultimap((Multimap)MultimapBuilder.hashKeys().hashSetValues().build());

    public <T> void updateValue(DataKey<T> dataKey, T object) {
        if (object == null) {
            this.cache.remove(dataKey);
        } else {
            this.cache.put(dataKey, object);
        }
        this.listeners.get(dataKey).forEach(consumer -> consumer.accept(object));
    }

    public <T> Optional<T> getValue(DataKey<T> dataKey) {
        return Optional.ofNullable(this.cache.get(dataKey));
    }

    public <T> T getRawValue(DataKey<T> dataKey) {
        return (T)this.cache.get(dataKey);
    }

    public void clear() {
        this.cache.keySet().forEach(key -> this.listeners.get(key).forEach(consumer -> consumer.accept(null)));
        this.cache.clear();
    }

    public <T> void registerValueChangeListener(DataKey<T> key, Consumer<T> listener) {
        this.listeners.put(key, listener);
    }

    public Map<DataKey<?>, Object> getMap() {
        return this.cache;
    }
}

